/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.authobj.util;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.SqlUtil;
import com.biz.eisp.base.utils.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.mdm.authobj.service.TmAuthExendsService;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.web.pojo.Client;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.jdbc.core.JdbcTemplate;

public class AuthObjHandler {
    private static TmOrgService tmOrgService;
    public static final String SQL = "select t.* from ({0}) t  where {1}";
    public static final String orgSubSql = " t.orgId in (select id from tm_org start with id='?' connect by  parent_id =prior id  )";
    public static final String custOrgSubSql = " t.customerOrgId in(select id from tm_customer_org start with id='?' connect by  parent_id =prior id  )";
    public static final String postSubSql = " t.positionId in(select id from tm_position start with id='?' connect by  parent_id =prior id  )";

    public static String executeAuthHandle(String sql) {
        String dataBase = ResourceUtil.getSysConfigProperty("dataBase");
        if ("mysql".equals(dataBase)) {
            return sql;
        }
        HttpServletRequest request = ContextHolderUtils.getRequest();
        if (request == null) {
            return sql;
        }
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis != null && "admin".equals(userRedis.getUsername())) {
            return sql;
        }
        String accessEntry = request.getParameter("accessEntry");
        if (StringUtil.isEmpty(accessEntry)) {
            return sql;
        }
        Client client = ResourceUtil.getClient();
        List<Map<String, Map<String, String>>> authObjList = client.getAuthObjList();
        Map funMap = (Map)client.getObj();
        String functionName = "";
        if (funMap != null && !funMap.isEmpty()) {
            functionName = (String)funMap.get(accessEntry);
        }
        Map<String, String> authMap = null;
        if (authObjList != null && authObjList.size() > 0) {
            for (Map<String, Map<String, String>> map : authObjList) {
                Map<String, String> m = map.get(accessEntry);
                if (m == null) continue;
                authMap = map.get(accessEntry);
            }
        }
        if (authMap != null && !authMap.isEmpty()) {
            Iterator it = authMap.entrySet().iterator();
            String sqlCondition = "(";
            while (it.hasNext()) {
                String sqlCon;
                Map.Entry entry = it.next();
                if (!AuthObjHandler.hasAuthObjSearchId(sql, (String)entry.getKey()) || !StringUtil.isNotEmpty((String)(sqlCon = AuthObjHandler.getAuthCondition((String)entry.getKey(), (String)entry.getValue(), functionName)))) continue;
                sqlCondition = sqlCondition + sqlCon + " or ";
            }
            if (sqlCondition.length() > 1) {
                Object[] sqlParam = new String[]{sql, sqlCondition.substring(0, sqlCondition.length() - 3) + ")"};
                sql = MessageFormat.format(SQL, sqlParam);
                TmAuthExendsService tmAuthExendsService = (TmAuthExendsService)ApplicationContextUtils.getContext().getBean("tmAuthExendsService");
                if (tmAuthExendsService != null) {
                    sql = tmAuthExendsService.extendsAuthobjSql(sql);
                }
                System.out.println("\u6743\u9650\u5904\u7406\u7ed3\u679c:" + sql);
            }
        }
        return sql;
    }

    private static boolean hasAuthObjSearchId(String sql, String authObj) {
        String authObjId = "";
        if (StringUtil.equals("user", authObj)) {
            authObjId = "userId";
        }
        if (StringUtil.equals("customer", authObj)) {
            authObjId = "customerId";
        }
        if (StringUtil.equals("customer_org", authObj)) {
            authObjId = "customerOrgId";
        }
        if (StringUtil.equals("terminal", authObj)) {
            authObjId = "terminalId";
        }
        if (StringUtil.equals("org", authObj)) {
            authObjId = "orgId";
        }
        if (StringUtil.equals("position", authObj)) {
            authObjId = "positionId";
        }
        return AuthObjHandler.checkQueryClounm(sql, authObjId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkQueryClounm(String sql, String authObjId) {
        ResultSet resultSet = null;
        Connection conn = null;
        Statement st = null;
        try {
            JdbcTemplate jdbcTemplate = (JdbcTemplate)ApplicationContextUtils.getContext().getBean("jdbcTemplate");
            conn = jdbcTemplate.getDataSource().getConnection();
            st = conn.createStatement();
            sql = sql.replace("?", "''");
            resultSet = st.executeQuery(sql);
            ResultSetMetaData rsmd = resultSet.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String columnName = rsmd.getColumnName(i);
                if (!StringUtil.equals(authObjId.toUpperCase(), columnName.toUpperCase())) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (BeansException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                st.close();
                resultSet.close();
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static String getAuthCondition(String authObj, String authObjValues, String functionName) {
        String sqlCondition = AuthObjHandler.getSqlConditionByAuthObjValue(authObj, authObjValues, functionName);
        if (StringUtil.isNotEmpty((String)sqlCondition)) {
            DynamicConfigUtil tableConfig = DynamicConfigUtil.getInstance();
            if (StringUtil.equals(authObj, "user")) {
                String sql = tableConfig.buildQuerySql(Globals.TABLE_USER, null);
                sqlCondition = " (t.userId in (select t.id from (" + sql + ") t where " + sqlCondition + " ))";
            } else if (StringUtil.equals(authObj, "terminal")) {
                String sql = tableConfig.buildQuerySql(Globals.TABLE_TERMINAL, null);
                sqlCondition = " (t.terminalId in (select t.id from (" + sql + ") t where " + sqlCondition + " ))";
            } else if (StringUtil.equals(authObj, "customer")) {
                if (StringUtil.equals(functionName, "\u7ec8\u7aef\u7ba1\u7406")) {
                    return sqlCondition;
                }
                String sql = tableConfig.buildQuerySql(Globals.Table_CUSTOMER, null);
                sqlCondition = " (t.customerId in (select t.id from (" + sql + ")  t where " + sqlCondition + " ))";
            }
        }
        return sqlCondition;
    }

    private static String getSqlConditionByAuthObjValue(String authObj, String authObjValues, String functionName) {
        List<Integer> objValues = AuthObjHandler.getFinalAuthObjValue(authObjValues);
        String sqlCondition = "";
        for (int i = 0; i < objValues.size(); ++i) {
            Integer objValue = objValues.get(i);
            sqlCondition = AuthObjHandler.getConditionByAuthObj(authObj, objValue, functionName);
            if (objValues.size() <= 1 || i + 1 == objValues.size()) continue;
            sqlCondition = sqlCondition + " or ";
        }
        return sqlCondition;
    }

    private static String getConditionByAuthObj(String authObj, Integer authObjValue, String functionName) {
        String newAuthObj = authObj;
        if (StringUtil.equals("user", authObj)) {
            newAuthObj = AuthObjHandler.getAuthObjByValue(authObjValue);
        }
        if (StringUtil.equals("terminal", authObj)) {
            newAuthObj = AuthObjHandler.getAuthObjByValue(authObjValue);
        }
        if (StringUtil.equals("customer", authObj)) {
            newAuthObj = AuthObjHandler.getAuthObjByValue(authObjValue);
        }
        if (StringUtil.equals(newAuthObj, "position") && StringUtil.isNotEmpty((String)functionName) && StringUtil.equals(functionName, "\u5ba2\u6237\u7ba1\u7406")) {
            return AuthObjHandler.getSpecialConForCustomerPost(authObjValue);
        }
        if (StringUtil.isNotEmpty((String)functionName) && StringUtil.equals(functionName, "\u7ec8\u7aef\u7ba1\u7406")) {
            if (StringUtil.equals("customer", authObj)) {
                return AuthObjHandler.getSpecialConForCustomer(authObjValue);
            }
            if (StringUtil.equals(newAuthObj, "position")) {
                return AuthObjHandler.getSpecialConForTerminalPost(authObjValue);
            }
        }
        return AuthObjHandler.getConditionByObjValue(newAuthObj, authObjValue);
    }

    private static String getSpecialConForCustomer(Integer authObjValue) {
        String sql = " exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3  on t3.terminal_id=t2.id where t2.id=to_char(t.id)";
        if (authObjValue == 40) {
            sql = sql + " and t3.customer_Id IN ( SELECT t.ID  FROM TM_customer t  LEFT JOIN TM_org t1 ON t1.id=t.org_id  LEFT JOIN TM_customer_org t2 ON t2.id=t.customer_org_id  LEFT JOIN TM_R_CUST_POS_BG t3 ON t3.customer_id =t.id   WHERE  t3.position_id in (select id from tm_position start with  id='" + ResourceUtil.getCurrPosition().getId() + "' connect by  parent_id =prior id ))";
        } else if (authObjValue == 50) {
            sql = sql + " and t3.customer_Id IN ( SELECT t.ID  FROM TM_customer t  LEFT JOIN TM_org t1 ON t1.id=t.org_id  LEFT JOIN TM_customer_org t2 ON t2.id=t.customer_org_id  LEFT JOIN TM_R_CUST_POS_BG t3 ON t3.customer_id =t.id   WHERE  t3.position_id='" + ResourceUtil.getCurrPosition().getId() + "')";
        } else if (authObjValue == 20) {
            sql = sql + " and t3.customer_Id IN ( SELECT t.ID  FROM TM_customer t   WHERE t.org_id in (select id from tm_org start with id='" + ResourceUtil.getCurrOrg().getId() + "' connect by  parent_id =prior id ))";
        } else if (authObjValue == 30) {
            sql = sql + " and t3.customer_Id IN ( SELECT t.ID  FROM TM_customer t   WHERE t.org_id ='" + ResourceUtil.getCurrOrg().getId() + "')";
        } else {
            return "";
        }
        sql = sql + ")";
        return sql;
    }

    private static String getSpecialConForCustomerPost(Integer authObjValue) {
        String sql = " exists(select 1 from TM_CUSTOMER t2 left join TM_R_CUST_POS_BG t3 on t3.customer_id=t2.id where t2.id=to_char(t.customerId) ";
        if (authObjValue == 40) {
            sql = sql + " and t3.position_id in (select id from tm_position start with id='" + ResourceUtil.getCurrPosition().getId() + "' connect by  parent_id =prior id )";
        } else if (authObjValue == 50) {
            sql = sql + " and t3.position_id='" + ResourceUtil.getCurrPosition().getId() + "'";
        } else {
            return "";
        }
        sql = sql + ")";
        return sql;
    }

    private static String getSpecialConForTerminalPost(Integer authObjValue) {
        String sql = " exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3 on t3.terminal_id=t2.id where t2.id=to_char(t.terminalId) ";
        String positionid = ResourceUtil.getCurrPosition().getId();
        if (authObjValue == 40) {
            sql = sql + " and t3.position_id in (select id from tm_position start with id='" + positionid + "' connect by  parent_id =prior id )";
        } else if (authObjValue == 50) {
            sql = sql + " and t3.position_id='" + positionid + "'";
        } else {
            return "";
        }
        sql = sql + ")";
        return sql;
    }

    private static String getAuthObjByValue(Integer objValue) {
        String authObj = "";
        switch (objValue) {
            case 20: {
                authObj = "org";
                break;
            }
            case 30: {
                authObj = "org";
                break;
            }
            case 40: {
                authObj = "position";
                break;
            }
            case 50: {
                authObj = "position";
            }
        }
        return authObj;
    }

    private static void initService() {
        if (tmOrgService == null) {
            tmOrgService = (TmOrgService)ApplicationContextUtils.getContext().getBean("tmOrgService");
        }
    }

    private static String getConditionByObjValue(String authObj, Integer objValue) {
        String sqlCondition = "";
        switch (objValue) {
            case 20: {
                if (StringUtil.equals("customer_org", authObj)) {
                    TmCustomerOrgEntity customerOrg = ResourceUtil.getCurrCustomerOrg();
                    if (customerOrg == null) break;
                    sqlCondition = sqlCondition + custOrgSubSql.replace("?", customerOrg.getId());
                    break;
                }
                if (!StringUtil.equals("org", authObj)) break;
                if ("mysql".equals(ResourceUtil.getSysConfigProperty("dataBase"))) {
                    String s;
                    AuthObjHandler.initService();
                    List<String> sqls = tmOrgService.findOrgListDowm(UserUtils.getUser().getOrgId());
                    sqlCondition = s = SqlUtil.setSqlInNotAnd(sqls.toArray(new String[sqls.size()]), "t.orgId", true, null);
                    break;
                }
                sqlCondition = sqlCondition + orgSubSql.replace("?", UserUtils.getUser().getOrgId());
                break;
            }
            case 30: {
                if (StringUtil.equals("customer_org", authObj)) {
                    TmCustomerOrgEntity customerOrg1 = ResourceUtil.getCurrCustomerOrg();
                    if (customerOrg1 == null) break;
                    sqlCondition = sqlCondition + "t.customerOrgId='" + customerOrg1.getId() + "'";
                    break;
                }
                if (!StringUtil.equals("org", authObj)) break;
                sqlCondition = sqlCondition + " t.orgId ='" + ResourceUtil.getCurrOrg().getId() + "'";
                break;
            }
            case 40: {
                sqlCondition = sqlCondition + postSubSql.replace("?", ResourceUtil.getCurrPosition().getId());
                break;
            }
            case 50: {
                sqlCondition = sqlCondition + " t.positionId ='" + ResourceUtil.getCurrPosition().getId() + "'";
            }
        }
        return sqlCondition;
    }

    private static List<Integer> getFinalAuthObjValue(String authObjValue) {
        String[] authObjValues = authObjValue.split(",");
        ArrayList<Integer> objValues = new ArrayList<Integer>();
        ArrayList authList = new ArrayList();
        Collections.addAll(authList, authObjValues);
        if (authList.contains("10")) {
            objValues.add(0, Integer.parseInt("10"));
            return objValues;
        }
        if (authList.contains("20") && authList.contains("30")) {
            objValues.add(objValues.size(), Integer.parseInt("20"));
        } else if (authList.contains("40") && authList.contains("50")) {
            objValues.add(objValues.size(), Integer.parseInt("40"));
        } else {
            int index = objValues.size();
            for (String str : authList) {
                objValues.add(index, Integer.parseInt(str));
                ++index;
            }
        }
        return objValues;
    }
}

