/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.TagUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.BeanUtils;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSONHelper {
    private static final Logger logger = LoggerFactory.getLogger(JSONHelper.class);

    public static String array2json(Object object) {
        JSONArray jsonArray = JSONArray.fromObject((Object)object);
        return jsonArray.toString();
    }

    public static Object json2Array(String json, Class valueClz) {
        JSONArray jsonArray = JSONArray.fromObject((Object)json);
        return JSONArray.toArray((JSONArray)jsonArray, (Class)valueClz);
    }

    public static String collection2json(Object object) {
        JSONArray jsonArray = JSONArray.fromObject((Object)object);
        return jsonArray.toString();
    }

    public static String map2json(Object object) {
        JSONObject jsonObject = JSONObject.fromObject((Object)object);
        return jsonObject.toString();
    }

    public static Map json2Map(Object[] keyArray, String json, Class valueClz) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        HashMap<Object, Class> classMap = new HashMap<Object, Class>();
        for (int i = 0; i < keyArray.length; ++i) {
            classMap.put(keyArray[i], valueClz);
        }
        return (Map)JSONObject.toBean((JSONObject)jsonObject, Map.class, classMap);
    }

    public static String bean2json(Object object) {
        JSONObject jsonObject = JSONObject.fromObject((Object)object);
        return jsonObject.toString();
    }

    public static Object json2Object(String json, Class beanClz) {
        return JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)json), (Class)beanClz);
    }

    public static <T> T fromJsonToObject(String json, Class<T> valueType) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, valueType);
        }
        catch (JsonParseException e) {
            logger.error("JsonParseException: ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("JsonMappingException: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException: ", (Throwable)e);
        }
        return null;
    }

    public static String string2json(String key, String value) {
        JSONObject object = new JSONObject();
        object.put((Object)key, (Object)value);
        return object.toString();
    }

    public static String json2String(String json, String key) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        return jsonObject.get(key).toString();
    }

    public static <T> String toJSONString(List<T> list) {
        JSONArray jsonArray = JSONArray.fromObject(list);
        return jsonArray.toString();
    }

    public static String toJSONString(Object object) {
        JSONArray jsonArray = JSONArray.fromObject((Object)object);
        return jsonArray.toString();
    }

    public static String toJSONString(JSONArray jsonArray) {
        return jsonArray.toString();
    }

    public static String toJSONString(JSONObject jsonObject) {
        return jsonObject.toString();
    }

    public static List toArrayList(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        JSONArray jsonArray = JSONArray.fromObject((Object)object);
        for (JSONObject jsonObject : jsonArray) {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object value = jsonObject.get(key);
                arrayList.add(value);
            }
        }
        return arrayList;
    }

    public static JSONArray toJSONArray(Object object) {
        return JSONArray.fromObject((Object)object);
    }

    public static JSONObject toJSONObject(Object object) {
        return JSONObject.fromObject((Object)object);
    }

    public static HashMap toHashMap(Object object) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        JSONObject jsonObject = JSONHelper.toJSONObject(object);
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = String.valueOf(it.next());
            Object value = jsonObject.get(key);
            data.put(key, value);
        }
        return data;
    }

    public static List<Map<String, Object>> toList(Object object) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        JSONArray jsonArray = JSONArray.fromObject((Object)object);
        for (Object obj : jsonArray) {
            JSONObject jsonObject = (JSONObject)obj;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = jsonObject.get(key);
                map.put(key, value);
            }
            list.add(map);
        }
        return list;
    }

    public static <T> List<T> toList(JSONArray jsonArray, Class<T> objectClass) {
        return JSONArray.toList((JSONArray)jsonArray, objectClass);
    }

    public static <T> List<T> toList(Object object, Class<T> objectClass) {
        JSONArray jsonArray = JSONArray.fromObject((Object)object);
        return JSONArray.toList((JSONArray)jsonArray, objectClass);
    }

    public static <T> T toBean(JSONObject jsonObject, Class<T> beanClass) {
        return (T)JSONObject.toBean((JSONObject)jsonObject, beanClass);
    }

    public static <T> T toBean(Object object, Class<T> beanClass) {
        JSONObject jsonObject = JSONObject.fromObject((Object)object);
        return (T)JSONObject.toBean((JSONObject)jsonObject, beanClass);
    }

    public static <T, D> T toBean(String jsonString, Class<T> mainClass, String detailName, Class<D> detailClass) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        JSONArray jsonArray = (JSONArray)jsonObject.get(detailName);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        List<D> detailList = JSONHelper.toList(jsonArray, detailClass);
        try {
            BeanUtils.setProperty(mainEntity, (String)detailName, detailList);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
        }
        return mainEntity;
    }

    public static <T, D1, D2> T toBean(String jsonString, Class<T> mainClass, String detailName1, Class<D1> detailClass1, String detailName2, Class<D2> detailClass2) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        JSONArray jsonArray1 = (JSONArray)jsonObject.get(detailName1);
        JSONArray jsonArray2 = (JSONArray)jsonObject.get(detailName2);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        List<D1> detailList1 = JSONHelper.toList(jsonArray1, detailClass1);
        List<D2> detailList2 = JSONHelper.toList(jsonArray2, detailClass2);
        try {
            BeanUtils.setProperty(mainEntity, (String)detailName1, detailList1);
            BeanUtils.setProperty(mainEntity, (String)detailName2, detailList2);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
        }
        return mainEntity;
    }

    public static <T, D1, D2, D3> T toBean(String jsonString, Class<T> mainClass, String detailName1, Class<D1> detailClass1, String detailName2, Class<D2> detailClass2, String detailName3, Class<D3> detailClass3) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        JSONArray jsonArray1 = (JSONArray)jsonObject.get(detailName1);
        JSONArray jsonArray2 = (JSONArray)jsonObject.get(detailName2);
        JSONArray jsonArray3 = (JSONArray)jsonObject.get(detailName3);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        List<D1> detailList1 = JSONHelper.toList(jsonArray1, detailClass1);
        List<D2> detailList2 = JSONHelper.toList(jsonArray2, detailClass2);
        List<D3> detailList3 = JSONHelper.toList(jsonArray3, detailClass3);
        try {
            BeanUtils.setProperty(mainEntity, (String)detailName1, detailList1);
            BeanUtils.setProperty(mainEntity, (String)detailName2, detailList2);
            BeanUtils.setProperty(mainEntity, (String)detailName3, detailList3);
        }
        catch (Exception ex) {
            throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
        }
        return mainEntity;
    }

    public static <T> T toBean(String jsonString, Class<T> mainClass, HashMap<String, Class> detailClass) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        T mainEntity = JSONHelper.toBean(jsonObject, mainClass);
        for (String key : detailClass.keySet()) {
            try {
                Class value = detailClass.get(key);
                BeanUtils.setProperty(mainEntity, (String)key.toString(), (Object)value);
            }
            catch (Exception ex) {
                throw new RuntimeException("\u4e3b\u4ece\u5173\u7cfbJSON\u53cd\u5e8f\u5217\u5316\u5b9e\u4f53\u5931\u8d25\uff01");
            }
        }
        return mainEntity;
    }

    public static String listtojson(String[] fields, int total, List list) throws Exception {
        Object[] values = new Object[fields.length];
        String jsonTemp = "{\"total\":" + total + ",\"rows\":[";
        for (int j = 0; j < list.size(); ++j) {
            jsonTemp = jsonTemp + "{\"state\":\"closed\",";
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i].toString();
                values[i] = TagUtil.fieldNametoValues(fieldName, list.get(j));
                jsonTemp = jsonTemp + "\"" + fieldName + "\"" + ":\"" + values[i] + "\"";
                if (i == fields.length - 1) continue;
                jsonTemp = jsonTemp + ",";
            }
            jsonTemp = j != list.size() - 1 ? jsonTemp + "}," : jsonTemp + "}";
        }
        jsonTemp = jsonTemp + "]}";
        return jsonTemp;
    }
}

