/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.redis.aop;

import com.biz.eisp.base.core.redis.annotation.ReadCacheType;
import com.biz.eisp.base.core.redis.annotation.UpdateThroughAssignCache;
import com.biz.eisp.base.core.redis.aop.CacheAdvice;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

abstract class SingleUpdateCacheAdvice
extends CacheAdvice {
    @Autowired
    private IRedisCacheService redisCacheService;

    SingleUpdateCacheAdvice() {
    }

    protected Object update(ProceedingJoinPoint pjp) throws Throwable {
        if (this.isEnable()) {
            this.getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        Method method = this.getMethod(pjp);
        UpdateThroughAssignCache cacheable = method.getAnnotation(UpdateThroughAssignCache.class);
        Signature sig = pjp.getSignature();
        MethodSignature msig = (MethodSignature)sig;
        if (cacheable != null && cacheable.cacheEnable()) {
            String namespace = cacheable.namespace();
            String assignedKey = cacheable.assignedKey();
            Annotation[][] anns = method.getParameterAnnotations();
            if (cacheable.cacheType() == ReadCacheType.Map) {
                String mapkey = this.getCacheKey(namespace, assignedKey, anns, pjp.getArgs());
                String valuekey = this.getCacheMapValueKey(anns, pjp.getArgs());
                Object value = null;
                value = pjp.proceed();
                if (value != null) {
                    this.redisCacheService.setMap(mapkey, valuekey, value);
                }
                return value;
            }
            String key = this.getCacheKey(namespace, assignedKey, anns, pjp.getArgs());
            Object value = null;
            if (cacheable.cacheType() == ReadCacheType.String) {
                value = pjp.proceed();
                if (value != null) {
                    this.redisCacheService.set(key, value, cacheable.expireTime());
                }
                return value;
            }
        } else {
            this.getLogger().info("Method cache disabled . Name {}", (Object)msig.getName());
            return pjp.proceed();
        }
        return null;
    }
}

