/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dict.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import com.biz.eisp.mdm.dict.service.TmDictDataService;
import com.biz.eisp.mdm.dict.service.TmDictTypeService;
import com.biz.eisp.mdm.dict.vo.DictTreeGrid;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmDictTypeController"})
public class TmDictTypeController
extends BaseController {
    @Autowired
    private TmDictTypeService tmDictTypeService;
    @Autowired
    private TmDictDataService tmDictDataService;

    @RequestMapping(params={"goDictMain"})
    public ModelAndView goDictMain() {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("com/biz/eisp/mdm/dict/dictMain");
        return modelAndView;
    }

    @RequestMapping(params={"deleteDictType"})
    @ResponseBody
    public AjaxJson deleteDictType(String id) {
        String realId = id.split("_")[0];
        String type = id.split("_")[1];
        AjaxJson ajaxJson = new AjaxJson();
        if (type.equals("2")) {
            this.tmDictDataService.deleteDictData(realId);
        } else {
            this.tmDictTypeService.deleteDictType(realId);
        }
        return ajaxJson;
    }

    @RequestMapping(params={"goSaveDictType"}, method={RequestMethod.GET})
    public ModelAndView goSaveDictType(HttpServletRequest req, HttpServletResponse response) {
        return new ModelAndView("com/biz/eisp/mdm/dict/dictTypeForm");
    }

    @RequestMapping(params={"saveOrUpdate"})
    @ResponseBody
    public AjaxJson saveOrUpdateDictType(DictTreeGrid dictTreegrid, HttpServletRequest req, HttpServletResponse response) {
        this.tmDictTypeService.saveAndUpdate(dictTreegrid);
        return new AjaxJson();
    }

    @RequestMapping(params={"goUpdateType"}, method={RequestMethod.GET})
    public ModelAndView goUpdateType(DictTreeGrid dictTreegrid, HttpServletRequest req, HttpServletResponse response) {
        TmDictTypeEntity t = this.tmDictTypeService.get(dictTreegrid.getId().split("_")[0]);
        DictTreeGrid dictgrid = new DictTreeGrid(t);
        req.setAttribute("dictTreegrid", (Object)dictgrid);
        return new ModelAndView("com/biz/eisp/mdm/dict/dictTypeForm");
    }

    @RequestMapping(params={"validateTypeCode"})
    @ResponseBody
    public ValidForm validateTypeCode(DictTreeGrid dictTreegrid, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)dictTreegrid.getId())) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)dictTreegrid.getId().split("_")[0]);
            SimpleExpression cr3 = Restrictions.eq((String)"dictTypeCode", (Object)param);
            List<TmDictTypeEntity> tmDictTypes = this.tmDictTypeService.findByCriteria(TmDictTypeEntity.class, new Criterion[]{cr2, cr3});
            if (!CollectionUtils.isEmpty(tmDictTypes)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else {
            List<TmDictTypeEntity> tmDictTypes = this.tmDictTypeService.findByProperty(TmDictTypeEntity.class, "dictTypeCode", param);
            if (!CollectionUtils.isEmpty(tmDictTypes)) {
                validForm.setStatus("n");
                validForm.setInfo("\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }
}

