/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.customer.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.customer.TmCustPostVo;
import com.biz.eisp.customer.TmCustomerResultVo;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.customer.entity.TmCustomerEntity;
import com.biz.eisp.customer.service.CustomerService;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u5ba2\u6237"}, description="CRM-MDM MDM\u5ba2\u6237")
@RestController
@RequestMapping(value={"/mdmApi/customerController"})
public class CustomerController {
    @Autowired
    private CustomerService customerService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5ba2\u6237\u5217\u8868", notes="\u67e5\u8be2\u83dc\u5355\u6700\u5e95\u5c42\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"customerCode\":\"\u5ba2\u6237\u7f16\u7801\",\"customerName\":\"\u5ba2\u6237\u6bcf\u6b21\",\"erpCode\":\"ERP\u7f16\u7801\",\"customerType\":\"\u5ba2\u6237\u7c7b\u578b\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerPage"})
    public AjaxJson<TmCustomerEntity> getCustomerPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmCustomerEntity> customerEntityPageInfo = this.customerService.getCustomerPage(param, page);
        ajaxJson.setPageInfo(customerEntityPageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636eid\u6216\u8005\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f", notes="\u6839\u636eid\u6216\u8005\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\uff0c\u8fd4\u56deObj", httpMethod="GET")
    @GetMapping(value={"getCustomerByIdOrCode"})
    public AjaxJson<TmCustomerVo> getCustomerByIdOrCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="customerCode", required=false) String customerCode) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setObj((Object)this.customerService.getCustomerByIdOrCode(id, customerCode));
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237/\u7ec8\u7aef\u5217\u8868", notes="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237/\u7ec8\u7aef\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"posId\":\"\u804c\u4f4did\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerByPosIdPage"})
    public AjaxJson<TmCustomerResultVo> getCustomerByPosIdPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmCustomerResultVo> pageInfo = this.customerService.getCustomerByPosIdPage(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237", notes="\u6839\u636e\u804c\u4f4d\u5206\u9875\u67e5\u8be2\u5ba2\u6237,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"posId\":\"\u804c\u4f4did\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"getCustomerByPosPage"})
    public AjaxJson<TmCustomerResultVo> getCustomerByPosPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmCustomerResultVo> pageInfo = this.customerService.getCustomerByPosPage(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237Code\u67e5\u8be2\u5ba2\u6237\u5197\u4f59\u4fe1\u606f", notes="\u6839\u636e\u5ba2\u6237code\u67e5\u8be2\u5ba2\u6237\u5197\u4f59\u4fe1\u606f\uff0c\u5197\u4f59\u4fe1\u606f\u5728list", httpMethod="GET")
    @GetMapping(value={"getCustomerDetailByCode"})
    public AjaxJson<TmCustPostVo> getCustomerDetailByCode(@RequestParam(value="customerCode", required=false) String customerCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmCustomerVo tmCustomerVo = this.customerService.getCustomerByIdOrCode(null, customerCode);
        if (tmCustomerVo != null) {
            List<TmCustPostVo> tmCustPostVos = this.customerService.findTmCustPostDetailList(tmCustomerVo.getId());
            ajaxJson.setObjList(tmCustPostVos);
        }
        return ajaxJson;
    }
}

