/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.wx.service.impl;

import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.CookiesUtil;
import com.biz.eisp.base.utils.Globals;
import com.biz.eisp.base.utils.Md5EncryptionAndDecryption;
import com.biz.eisp.base.utils.Snippet;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.user.LoginUserVo;
import com.biz.eisp.user.dao.TmUserDao;
import com.biz.eisp.user.entity.TmUserEntity;
import com.biz.eisp.wx.dao.TmWxOpenIdDao;
import com.biz.eisp.wx.entity.TmWxOpenIdEntity;
import com.biz.eisp.wx.service.LoginService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private RedisService redisService;
    @Autowired
    private TmUserDao tmUserDao;
    @Autowired
    private TmWxOpenIdDao tmWxOpenIdDao;

    @Override
    public AjaxJson validateUserWx(LoginUserVo loginUserVo) {
        AjaxJson ajaxJson = new AjaxJson();
        String configLoginErrTimes = "5";
        int errTime = Integer.valueOf(configLoginErrTimes);
        Object object = this.redisService.get("MDM_LOGIN_" + loginUserVo.getUsername());
        int time = 0;
        if (StringUtil.isNotEmpty((Object)object) && (time = Integer.valueOf(object.toString()).intValue()) > errTime) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc75\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
            return ajaxJson;
        }
        List<TmUserEntity> list = this.getUserList(loginUserVo.getUsername());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            TmUserEntity userEntity = list.get(0);
            if (Globals.ONE.equals(userEntity.getEnableStatus())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u8be5\u7ecf\u9500\u5546\u5e10\u53f7\u5df2\u7ecf\u88ab\u7981\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return ajaxJson;
            }
            String pwd = loginUserVo.getPassword();
            if (!(pwd = Md5EncryptionAndDecryption.encryPwd((String)pwd)).equals(userEntity.getPassword())) {
                ajaxJson.setSuccess(false);
                this.redisService.setDays("MDM_LOGIN_" + loginUserVo.getUsername(), (Object)(++time), 1L);
                if (time >= errTime) {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef\u8d85\u8fc7" + errTime + "\u6b21\uff0c\u5c06\u9501\u5b9a24\u5c0f\u65f6");
                } else {
                    ajaxJson.setMsg("\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + (errTime - time) + "\u673a\u4f1a");
                }
                return ajaxJson;
            }
            this.redisService.del(new String[]{"MDM_LOGIN_" + loginUserVo.getUsername()});
            boolean flag = false;
            Example exOp = new Example(TmUserEntity.class);
            Example.Criteria crop = exOp.createCriteria();
            crop.andEqualTo("username", (Object)loginUserVo.getUsername());
            List wxOpenIdList = this.tmWxOpenIdDao.selectByExample(exOp);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)wxOpenIdList)) {
                if (wxOpenIdList.size() > 1) {
                    throw new BusinessException("\u8be5\u8d26\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u591a\u4e2a\u5fae\u4fe1\uff0c\u6e05\u5148\u89e3\u7ed1");
                }
                for (TmWxOpenIdEntity item : wxOpenIdList) {
                    if (!StringUtil.isNotEmpty((CharSequence)loginUserVo.getOpenId()) || !loginUserVo.getOpenId().equals(item.getOpenid())) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                TmWxOpenIdEntity newWxOpenIdEntity = new TmWxOpenIdEntity();
                newWxOpenIdEntity.setUsername(loginUserVo.getUsername());
                newWxOpenIdEntity.setOpenid(loginUserVo.getOpenId());
                newWxOpenIdEntity.setCreateDate(new Date());
                this.tmWxOpenIdDao.insert(newWxOpenIdEntity);
            }
            try {
                String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)loginUserVo.getUsername()), (String)"1oR8uIM2O5qv65l2");
                UserRedis userRedis = this.createUserRedis(userEntity, Globals.LOGIN_SOURCE_WX);
                userRedis.setOpenId(loginUserVo.getOpenId());
                String value = JSON.toJSONString((Object)userRedis);
                String redisKey = "LOGIN_SUCCESS_" + key;
                this.redisService.setDays(redisKey, (Object)value, 1825L);
                ajaxJson.setFlagId(key);
                ajaxJson.setObj((Object)userRedis);
            }
            catch (Exception e) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u64cd\u4f5c\u5904\u7406\u5f02\u5e38");
            }
            ajaxJson.setSuccess(true);
            ajaxJson.setMsg("\u767b\u5f55\u6210\u529f");
            return ajaxJson;
        }
        ajaxJson.setSuccess(false);
        ajaxJson.setMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        return ajaxJson;
    }

    private List<TmUserEntity> getUserList(String userName) {
        Example example = new Example(TmUserEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("username", (Object)userName);
        ArrayList<String> types = new ArrayList<String>();
        types.add("0");
        types.add("1");
        criteria.andIn("userType", types);
        return this.tmUserDao.selectByExample(example);
    }

    @Override
    public AjaxJson autoLoginWx(String openId) {
        AjaxJson j = new AjaxJson();
        Example example = new Example(TmWxOpenIdEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("openid", (Object)openId);
        List opens = this.tmWxOpenIdDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)opens)) {
            List<TmUserEntity> entities = this.getUserList(((TmWxOpenIdEntity)opens.get(0)).getUsername());
            if (CollectionUtil.listNotEmptyNotSizeZero(entities)) {
                TmUserEntity entity = entities.get(0);
                if (!Globals.ZERO.equals(entity.getEnableStatus())) {
                    j.setSuccess(false);
                    j.setMsg("\u8d26\u53f7:" + entity.getUsername() + ",\u5df2\u7ecf\u9501\u5b9a\uff0c\u8bf7\u89e3\u9501\u540e\u518d\u767b\u5f55\uff01");
                    return j;
                }
                try {
                    String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)entity.getUsername()), (String)"1oR8uIM2O5qv65l2");
                    UserRedis userRedis = this.createUserRedis(entity, Globals.LOGIN_SOURCE_WX);
                    userRedis.setOpenId(openId);
                    String value = JSONUtils.toJSONString((Object)userRedis);
                    String redisKey = "LOGIN_SUCCESS_" + key;
                    this.redisService.setDays(redisKey, (Object)value, 1825L);
                    j.setFlagId(key);
                    j.setObj((Object)userRedis);
                }
                catch (Exception e) {
                    j.setSuccess(false);
                    j.setMsg("\u64cd\u4f5c\u5904\u7406\u5f02\u5e38");
                }
            }
        } else {
            j.setSuccess(false);
            j.setMsg("");
        }
        return j;
    }

    public UserRedis createUserRedis(TmUserEntity tmUserEntity, String loginSource) {
        UserRedis userRedis = new UserRedis();
        userRedis.setId(tmUserEntity.getId());
        userRedis.setRealname(tmUserEntity.getFullname());
        userRedis.setUsername(tmUserEntity.getUsername());
        userRedis.setStaffcode(tmUserEntity.getExtChar1());
        userRedis.setUsertype(Integer.valueOf(Integer.parseInt(tmUserEntity.getUserType())));
        userRedis.setLoginSource(loginSource);
        return userRedis;
    }
}

