/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.user.service.impl;

import com.biz.eisp.actuser.vo.MdmActIdUserVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.base.utils.Md5EncryptionAndDecryption;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.dao.PositionDao;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.user.dao.TmUserDao;
import com.biz.eisp.user.entity.TmUserEntity;
import com.biz.eisp.user.service.UserService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class UserServiceImpl
implements UserService {
    @Autowired
    private TmUserDao tmUserDao;
    @Autowired
    private PositionDao positionDao;
    @Autowired
    RedisService redisService;

    @Override
    public TmUserVo getTmUser(TmUserQueryVo tmUserQueryVo) {
        TmUserVo tmUserVo = new TmUserVo();
        if (tmUserQueryVo == null) {
            return null;
        }
        boolean userFlag = false;
        Example example = new Example(TmUserEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)tmUserQueryVo.getId())) {
            criteria.andEqualTo("id", (Object)tmUserQueryVo.getId());
            userFlag = true;
        }
        if (StringUtil.isNotEmpty((CharSequence)tmUserQueryVo.getUsername())) {
            criteria.andEqualTo("username", (Object)tmUserQueryVo.getUsername());
            userFlag = true;
        }
        if (userFlag) {
            List userRoleList = this.tmUserDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)userRoleList)) {
                BeanUtils.copyProperties(userRoleList.get(0), (Object)tmUserVo);
                return tmUserVo;
            }
        } else {
            List<TmUserVo> tmUserVos = this.tmUserDao.getTmUserByPosition(tmUserQueryVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmUserVos)) {
                tmUserVo = tmUserVos.get(0);
            }
            return tmUserVo;
        }
        return null;
    }

    @Override
    public List<TmUserVo> getAllUserList(TmUserQueryVo tmUserVo) {
        if (tmUserVo == null) {
            return null;
        }
        List<TmUserVo> tmUserEntities = this.tmUserDao.findAllUserDetail(tmUserVo);
        return tmUserEntities;
    }

    @Override
    public PageInfo<TmUserVo> getAllUserAndPositionList(Map<String, Object> param, Page page) {
        TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
        tmUserQueryVo.setUsername(OConvertUtils.getString((Object)param.get("username")));
        tmUserQueryVo.setRealName(OConvertUtils.getString((Object)param.get("realName")));
        tmUserQueryVo.setPosId(OConvertUtils.getString((Object)param.get("posId")));
        tmUserQueryVo.setPosCode(OConvertUtils.getString((Object)param.get("posCode")));
        tmUserQueryVo.setPosName(OConvertUtils.getString((Object)param.get("posName")));
        tmUserQueryVo.setOrgCode(OConvertUtils.getString((Object)param.get("orgCode")));
        tmUserQueryVo.setOrgName(OConvertUtils.getString((Object)param.get("orgName")));
        tmUserQueryVo.setUserType(OConvertUtils.getString((Object)param.get("userType")));
        return PageAutoHelperUtil.generatePage(() -> this.tmUserDao.getAllUserAndPositionList(tmUserQueryVo), (Page)page);
    }

    @Override
    public PageInfo<MdmActIdUserVo> findMdmActIdUserPageListByVoUseuser(MdmActIdUserVo voInfo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tmUserDao.findMdmActIdUserPageListByVoUseuser(voInfo), (Page)page);
    }

    @Override
    public PageInfo<TmUserVo> getDownUserByCon(Map<String, Object> param) {
        String userId = OConvertUtils.getString((Object)param.get("userId"));
        List<TmPositionVo> pos = this.positionDao.getOrgPosByUserId(userId);
        List orgs = null;
        if (!CollectionUtil.listNotEmptyNotSizeZero(pos)) {
            throw new BusinessException("\u65e0\u4e0b\u7ea7\u4eba\u5458");
        }
        orgs = pos.stream().map(TmPositionVo::getOrgCode).collect(Collectors.toList());
        EuPage page = new EuPage();
        page.setPage(OConvertUtils.getString((String)((String)page.get((Object)"page"))));
        page.setRows(OConvertUtils.getString((String)((String)page.get((Object)"rows"))));
        List finalOrgs = orgs;
        TmUserVo user = new TmUserVo();
        user.setPosCode(OConvertUtils.getString((Object)param.get("posCode")));
        user.setPosName(OConvertUtils.getString((Object)param.get("posName")));
        user.setUsername(OConvertUtils.getString((Object)param.get("userName")));
        user.setFullname(OConvertUtils.getString((Object)param.get("fullName")));
        return PageAutoHelperUtil.generatePage(() -> this.tmUserDao.getDownUserByCon(user, finalOrgs), (Page)page);
    }

    @Override
    public List<TmUserQueryVo> getOwnUserinfo() {
        UserRedis userService = UserUtils.getUser();
        return this.tmUserDao.getOwnUserinfo(userService.getId());
    }

    @Override
    public AjaxJson changeUserPassword(String username, String oldPas, String newPas) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)username)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u8d26\u53f7\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)oldPas)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u539f\u59cb\u5bc6\u7801\u5fc5\u4f20");
            return ajaxJson;
        }
        if (StringUtil.isEmpty((String)newPas)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u65b0\u5bc6\u7801\u5fc5\u4f20");
            return ajaxJson;
        }
        String password = Md5EncryptionAndDecryption.encryPwd((String)oldPas);
        TmUserEntity tmUserEntity = new TmUserEntity();
        tmUserEntity.setUsername(username);
        TmUserEntity entity = (TmUserEntity)this.tmUserDao.selectOne(tmUserEntity);
        if (!StringUtil.equals((String)password, (String)entity.getPassword())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u539f\u5bc6\u7801\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u65b0\u8f93\u5165\u539f\u5bc6\u7801");
            return ajaxJson;
        }
        String newpassword = Md5EncryptionAndDecryption.encryPwd((String)newPas);
        if (StringUtil.equals((String)entity.getPassword(), (String)newpassword)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u4e0d\u80fd\u8bbe\u7f6e\u76f8\u540c\u7684\u5bc6\u7801");
            return ajaxJson;
        }
        entity.setPassword(newpassword);
        this.tmUserDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public AjaxJson signOut() {
        AjaxJson ajaxJson = new AjaxJson();
        String key = AppcenterUtil.getUserKey();
        if (StringUtil.isNotEmpty((CharSequence)key) && this.redisService.hasKey("LOGIN_SUCCESS_" + key)) {
            this.redisService.del(new String[]{"LOGIN_SUCCESS_" + key});
        }
        return ajaxJson;
    }

    @Override
    public PageInfo<TmUserVo> findAllUserDetailPage(TmUserQueryVo tmUserVo, Page page) {
        if (tmUserVo == null) {
            return null;
        }
        List<TmUserVo> tmUserEntities = this.tmUserDao.findAllUserDetail(tmUserVo);
        return PageAutoHelperUtil.generatePage(() -> tmUserEntities, (Page)page);
    }
}

