/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ware.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.price.PriceParamVo;
import com.biz.eisp.price.PriceReturnVo;
import com.biz.eisp.price.PriceWareReturnVo;
import com.biz.eisp.product.entity.TmProductInfoEntity;
import com.biz.eisp.product.service.TmProductInfoService;
import com.biz.eisp.productPrice.service.TmProductPriceService;
import com.biz.eisp.ware.dao.TmWareInfoDao;
import com.biz.eisp.ware.dao.TmWarePicDao;
import com.biz.eisp.ware.dao.TmWareProductDao;
import com.biz.eisp.ware.dao.TmWareSalerangeDao;
import com.biz.eisp.ware.dao.TmWareTextDao;
import com.biz.eisp.ware.entity.TmWareInfoEntity;
import com.biz.eisp.ware.entity.TmWarePicEntity;
import com.biz.eisp.ware.entity.TmWareProductEntity;
import com.biz.eisp.ware.entity.TmWareSalerangeEntity;
import com.biz.eisp.ware.entity.TmWareTextEntity;
import com.biz.eisp.ware.service.TmWareInfoService;
import com.biz.eisp.ware.vo.FindWarePriceVo;
import com.biz.eisp.ware.vo.TmWareInfoPriceVo;
import com.biz.eisp.ware.vo.TmWareInfoVo;
import com.biz.eisp.ware.vo.TmWarePicVo;
import com.biz.eisp.ware.vo.TmWareProductVo;
import com.biz.eisp.ware.vo.TmWareSalerangeVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmWareInfoServiceImpl
implements TmWareInfoService {
    @Autowired
    private TmWareInfoDao tmWareInfoDao;
    @Autowired
    private TmWareProductDao tmWareProductDao;
    @Autowired
    private TmWareSalerangeDao tmWareSalerangeDao;
    @Autowired
    private TmWarePicDao tmWarePicDao;
    @Autowired
    private TmWareTextDao tmWareTextDao;
    @Autowired
    private OrgService orgService;
    @Autowired
    private TmProductPriceService tmProductPriceService;
    @Autowired
    private TmProductInfoService tmProductInfoService;

    @Override
    public PageInfo<TmWareInfoVo> findTmWareInfoPage(Map<String, Object> param, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findTmWareInfoList(param), (Page)page);
    }

    @Override
    public PageInfo<TmWareInfoEntity> findWareInfoPriceByPage(Map<String, Object> param, Page page, List<String> notCodes) {
        Example example = new Example(TmWareInfoEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("wareCode"))) {
            criteria.andEqualTo("wareCode", param.get("wareCode"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("wareName"))) {
            criteria.andLike("wareName", "%" + param.get("wareName") + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("barCode"))) {
            criteria.andEqualTo("barCode", param.get("barCode"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("shelfStatus"))) {
            criteria.andEqualTo("shelfStatus", param.get("shelfStatus"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("rebateStatus"))) {
            criteria.andEqualTo("rebateStatus", param.get("rebateStatus"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("warePriority"))) {
            criteria.andEqualTo("warePriority", param.get("warePriority"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("brand"))) {
            criteria.andEqualTo("brand", param.get("brand"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("category"))) {
            criteria.andEqualTo("category", param.get("category"));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(notCodes)) {
            criteria.andNotIn("wareCode", notCodes);
        }
        return PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.selectByExample(example), (Page)page);
    }

    @Override
    public List<TmWareInfoEntity> findTmWareInfoList(TmWareInfoVo vo) {
        Example example = new Example(TmWareInfoEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareCode())) {
            criteria.andEqualTo("wareCode", (Object)vo.getWareCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareName())) {
            criteria.andLike("wareName", "%" + vo.getWareName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getBarCode())) {
            criteria.andEqualTo("barCode", (Object)vo.getBarCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getShelfStatus())) {
            criteria.andEqualTo("shelfStatus", (Object)vo.getShelfStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getRebateStatus())) {
            criteria.andEqualTo("rebateStatus", (Object)vo.getRebateStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getWarePriority())) {
            criteria.andEqualTo("warePriority", (Object)vo.getWarePriority());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getBrand())) {
            criteria.andEqualTo("brand", (Object)vo.getBrand());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getCategory())) {
            criteria.andEqualTo("category", (Object)vo.getCategory());
        }
        return this.tmWareInfoDao.selectByExample(example);
    }

    @Override
    public TmWareInfoEntity getTmWareInfoEntityById(String id) {
        return (TmWareInfoEntity)this.tmWareInfoDao.selectByPrimaryKey(id);
    }

    @Override
    public boolean delete(String id) {
        TmWareInfoEntity tmWareInfoEntity = (TmWareInfoEntity)this.tmWareInfoDao.selectByPrimaryKey(id);
        int i = this.tmWareInfoDao.delete(tmWareInfoEntity);
        if (i > 0) {
            this.deleteWareProduct(tmWareInfoEntity.getWareCode());
            this.deleteWareSaleRange(tmWareInfoEntity.getWareCode());
            this.deleteWarePic(tmWareInfoEntity.getWareCode());
            this.deleteWareText(tmWareInfoEntity.getWareCode());
        }
        return i > 0;
    }

    @Override
    public void save(TmWareInfoVo vo) {
        TmWareInfoEntity entity = new TmWareInfoEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareInfoEntity(vo);
            this.tmWareInfoDao.insertSelective(entity);
        }
    }

    @Override
    public void update(TmWareInfoVo vo) {
        TmWareInfoEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareInfoEntity(vo);
            this.tmWareInfoDao.updateByPrimaryKeySelective(entity);
        }
    }

    private TmWareInfoEntity getTmWareInfoEntity(TmWareInfoVo vo) {
        TmWareInfoEntity entity = new TmWareInfoEntity();
        entity.setId(vo.getId());
        entity.setProductLevelCode(vo.getProductLevelCode());
        entity.setProductLevelName(vo.getProductLevelName());
        entity.setBarCode(vo.getBarCode());
        entity.setBrand(vo.getBrand());
        entity.setCategory(vo.getCategory());
        entity.setDeleteStatus(vo.getDeleteStatus());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setIsMarketMateriel(vo.getIsMarketMateriel());
        entity.setMaterielDesc(vo.getMaterielDesc());
        entity.setRebateStatus(vo.getRebateStatus());
        entity.setSaleUnit(vo.getSaleUnit());
        entity.setMeterUnit(vo.getMeterUnit());
        entity.setSpecification(vo.getSpecification());
        entity.setWareCode(vo.getWareCode());
        entity.setWareName(vo.getWareName());
        entity.setWarePriority(vo.getWarePriority());
        entity.setShelfStatus(vo.getShelfStatus());
        return entity;
    }

    @Override
    public AjaxJson saveWareProduct(TmWareInfoVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        String wareId = vo.getId();
        if (StringUtil.isNotEmpty((CharSequence)wareId)) {
            if (vo.getTmWareProductVos().size() > 1) {
                vo.setIsPortfolio(ConstantEnum.YesNoEnum.ONE.getValue());
            } else {
                vo.setIsPortfolio(ConstantEnum.YesNoEnum.ZERO.getValue());
            }
            this.update(vo);
            this.saveWareProduct(vo.getWareCode(), vo.getTmWareProductVos());
            this.saveWareSaleRange(vo.getWareCode(), vo.getTmWareSalerangeVos());
            this.saveWarePic(vo.getWareCode(), vo.getUrlPath(), vo.getTmWarePicVos());
            this.saveWareText(vo.getWareCode(), vo.getWareText());
        } else {
            TmWareInfoVo tmWareInfoVo = new TmWareInfoVo();
            tmWareInfoVo.setWareCode(vo.getWareCode());
            List<TmWareInfoEntity> tmWareInfoEntities = this.findTmWareInfoList(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmWareInfoEntities)) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u8be5\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
            } else {
                if (vo.getTmWareProductVos().size() > 1) {
                    vo.setIsPortfolio(ConstantEnum.YesNoEnum.ONE.getValue());
                } else {
                    vo.setIsPortfolio(ConstantEnum.YesNoEnum.ZERO.getValue());
                }
                this.save(vo);
                this.saveWareProduct(vo.getWareCode(), vo.getTmWareProductVos());
                this.saveWareSaleRange(vo.getWareCode(), vo.getTmWareSalerangeVos());
                this.saveWarePic(vo.getWareCode(), vo.getUrlPath(), vo.getTmWarePicVos());
                this.saveWareText(vo.getWareCode(), vo.getWareText());
            }
        }
        return ajaxJson;
    }

    private void saveWareProduct(String wareCode, List<TmWareProductVo> tmWareProductVos) {
        this.deleteWareProduct(wareCode);
        ArrayList tmWareProductEntities = new ArrayList();
        tmWareProductVos.forEach(item -> {
            TmWareProductEntity entity = new TmWareProductEntity();
            BeanUtils.copyProperties((Object)item, (Object)entity);
            entity.setWareCode(wareCode);
            tmWareProductEntities.add(entity);
        });
        this.tmWareProductDao.insertList(tmWareProductEntities);
    }

    private void deleteWareProduct(String wareCode) {
        Example exampleWareProduct = new Example(TmWareProductEntity.class);
        Example.Criteria criteria = exampleWareProduct.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWareProductDao.selectByExample(exampleWareProduct);
        entities.forEach(item -> this.tmWareProductDao.delete(item));
    }

    private void saveWareSaleRange(String wareCode, List<TmWareSalerangeVo> tmWareSalerangeVos) {
        this.deleteWareSaleRange(wareCode);
        ArrayList tmWareSalerangeEntities = new ArrayList();
        if (CollectionUtil.listNotEmptyNotSizeZero(tmWareSalerangeVos)) {
            tmWareSalerangeVos.forEach(item -> {
                TmWareSalerangeEntity entity = new TmWareSalerangeEntity();
                BeanUtils.copyProperties((Object)item, (Object)entity);
                entity.setWareCode(wareCode);
                tmWareSalerangeEntities.add(entity);
            });
            this.tmWareSalerangeDao.insertList(tmWareSalerangeEntities);
        } else {
            TmWareSalerangeEntity entity = new TmWareSalerangeEntity();
            entity.setOrgCode("ALL");
            entity.setContainStatus("1");
            entity.setContainObjType("0");
            entity.setWareCode(wareCode);
            this.tmWareSalerangeDao.insert(entity);
        }
    }

    private void deleteWareSaleRange(String wareCode) {
        Example exampleWareSalerange = new Example(TmWareSalerangeEntity.class);
        Example.Criteria criteria = exampleWareSalerange.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWareSalerangeDao.selectByExample(exampleWareSalerange);
        entities.forEach(item -> this.tmWareSalerangeDao.delete(item));
    }

    private void saveWarePic(String wareCode, String urlPath, List<TmWarePicVo> tmWarePicVos) {
        this.deleteWarePic(wareCode);
        TmWarePicEntity entity = new TmWarePicEntity();
        entity.setUrlPath(urlPath);
        entity.setWareCode(wareCode);
        entity.setPicType(ConstantEnum.picTypeEnum.INDEX.getValue());
        this.tmWarePicDao.insert(entity);
        ArrayList tmWarePicEntities = new ArrayList();
        tmWarePicVos.forEach(item -> {
            TmWarePicEntity warePicEntity = new TmWarePicEntity();
            BeanUtils.copyProperties((Object)item, (Object)warePicEntity);
            warePicEntity.setPicType(ConstantEnum.picTypeEnum.DETAIL.getValue());
            warePicEntity.setWareCode(wareCode);
            tmWarePicEntities.add(warePicEntity);
        });
        this.tmWarePicDao.insertList(tmWarePicEntities);
    }

    private void deleteWarePic(String wareCode) {
        Example exampleWarePic = new Example(TmWarePicEntity.class);
        Example.Criteria criteria = exampleWarePic.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWarePicDao.selectByExample(exampleWarePic);
        entities.forEach(item -> this.tmWarePicDao.delete(item));
    }

    private void saveWareText(String wareCode, String wareText) {
        this.deleteWareText(wareCode);
        TmWareTextEntity entity = new TmWareTextEntity();
        entity.setWareText(wareText);
        entity.setWareCode(wareCode);
        this.tmWareTextDao.insert(entity);
    }

    private void deleteWareText(String wareCode) {
        Example exampleWareText = new Example(TmWareTextEntity.class);
        Example.Criteria criteria = exampleWareText.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWareTextDao.selectByExample(exampleWareText);
        entities.forEach(item -> this.tmWareTextDao.delete(item));
    }

    @Override
    public List<PriceWareReturnVo> getStandPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceWareReturnVo> priceWareReturnVos = new ArrayList<PriceWareReturnVo>();
        List productCodes = priceParamVo.getProductCodes();
        List<TmWareProductVo> tmWareProductVos = this.tmWareProductDao.getTmWareProductListByWareCodes(productCodes);
        ArrayList productInfoCodes = new ArrayList();
        tmWareProductVos.forEach(item -> productInfoCodes.add(item.getProductInfoCode()));
        PriceParamVo paramVo = new PriceParamVo();
        paramVo.setProductCodes(productInfoCodes);
        paramVo.setPriceGroup(priceParamVo.getPriceGroup());
        paramVo.setCustCode(priceParamVo.getCustCode());
        paramVo.setPriceType(priceParamVo.getPriceType());
        paramVo.setPriceDate(priceParamVo.getPriceDate());
        List<PriceReturnVo> priceReturnVos = this.tmProductPriceService.getPriceReturnVos(paramVo);
        HashMap productInfoCodeMap = new HashMap();
        priceReturnVos.forEach(item -> productInfoCodeMap.put(item.getProductInfoCode(), item.getPriceAmount()));
        HashMap listMap = new HashMap();
        List<TmWareInfoVo> tmWareInfoVos = this.tmWareInfoDao.findTmWareInfoListByWareCodes(productCodes);
        tmWareInfoVos.forEach(item -> listMap.put(item.getWareCode(), item.getTmWareProductVos()));
        if (!listMap.isEmpty()) {
            for (Map.Entry entry : listMap.entrySet()) {
                PriceWareReturnVo priceWareReturnVo = new PriceWareReturnVo();
                BigDecimal priceAmount = new BigDecimal(0);
                List wareProductVos = (List)entry.getValue();
                for (TmWareProductVo tmWareProductVo : wareProductVos) {
                    if (!productInfoCodeMap.containsKey(tmWareProductVo.getProductInfoCode())) {
                        priceAmount = new BigDecimal(0);
                        break;
                    }
                    BigDecimal bigDecimal = ((BigDecimal)productInfoCodeMap.get(tmWareProductVo.getProductInfoCode())).multiply(new BigDecimal(tmWareProductVo.getProductNum()));
                    priceAmount = priceAmount.add(bigDecimal);
                }
                if (priceAmount.equals(BigDecimal.ZERO)) continue;
                priceWareReturnVo.setWareCode((String)entry.getKey());
                priceWareReturnVo.setPriceAmount(priceAmount);
                priceWareReturnVos.add(priceWareReturnVo);
            }
        }
        return priceWareReturnVos;
    }

    @Override
    public List<PriceWareReturnVo> getCostPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceWareReturnVo> priceWareReturnVos = new ArrayList<PriceWareReturnVo>();
        List productCodes = priceParamVo.getProductCodes();
        List<TmWareProductVo> tmWareProductVos = this.tmWareProductDao.getTmWareProductListByWareCodes(productCodes);
        ArrayList<String> productInfoCodes = new ArrayList<String>();
        tmWareProductVos.forEach(item -> productInfoCodes.add(item.getProductInfoCode()));
        List<TmProductInfoEntity> tmProductInfoEntities = this.tmProductInfoService.getTmProductInfoEntityByCodes(productInfoCodes);
        HashMap productInfoCodeMap = new HashMap();
        tmProductInfoEntities.forEach(item -> productInfoCodeMap.put(item.getProductInfoCode(), item.getCostPrice()));
        HashMap listMap = new HashMap();
        List<TmWareInfoVo> tmWareInfoVos = this.tmWareInfoDao.findTmWareInfoListByWareCodes(productCodes);
        tmWareInfoVos.forEach(item -> listMap.put(item.getWareCode(), item.getTmWareProductVos()));
        if (!listMap.isEmpty()) {
            for (Map.Entry entry : listMap.entrySet()) {
                PriceWareReturnVo priceWareReturnVo = new PriceWareReturnVo();
                BigDecimal priceAmount = new BigDecimal(0);
                List wareProductVos = (List)entry.getValue();
                for (TmWareProductVo tmWareProductVo : wareProductVos) {
                    if (StringUtil.isEmpty(productInfoCodeMap.get(tmWareProductVo.getProductInfoCode()))) {
                        priceAmount = new BigDecimal(0);
                        break;
                    }
                    BigDecimal bigDecimal = ((BigDecimal)productInfoCodeMap.get(tmWareProductVo.getProductInfoCode())).multiply(new BigDecimal(tmWareProductVo.getProductNum()));
                    priceAmount = priceAmount.add(bigDecimal);
                }
                if (priceAmount.equals(BigDecimal.ZERO)) continue;
                priceWareReturnVo.setWareCode((String)entry.getKey());
                priceWareReturnVo.setPriceAmount(priceAmount);
                priceWareReturnVos.add(priceWareReturnVo);
            }
        }
        return priceWareReturnVos;
    }

    @Override
    public List<TmWareInfoEntity> getAllNoStandPriceWare(TmWareInfoVo tmWareInfoVo, List<PriceWareReturnVo> priceReturnVos) {
        List productInfoEntities = this.tmWareInfoDao.selectAll();
        List productCodes = productInfoEntities.stream().map(TmWareInfoEntity::getWareCode).collect(Collectors.toList());
        PriceParamVo priceParamVo = new PriceParamVo(productCodes, tmWareInfoVo.getPriceGroup(), tmWareInfoVo.getCustCode());
        ArrayList priceReturnVos1 = this.getStandPriceReturnVos(priceParamVo);
        priceReturnVos1 = priceReturnVos1 == null ? new ArrayList() : priceReturnVos1;
        priceReturnVos.addAll(priceReturnVos1);
        Map<String, String> mapPrice = priceReturnVos1.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, PriceWareReturnVo::getWareCode));
        for (int i = 0; i < productInfoEntities.size(); ++i) {
            if (!mapPrice.containsKey(((TmWareInfoEntity)productInfoEntities.get(i)).getWareCode())) continue;
            productInfoEntities.remove(i);
            --i;
        }
        return productInfoEntities;
    }

    @Override
    public List<TmWareInfoEntity> getAllNoCostPriceWare(TmWareInfoVo tmWareInfoVo, List<PriceWareReturnVo> priceReturnVos) {
        List productInfoEntities = this.tmWareInfoDao.selectAll();
        List productCodes = productInfoEntities.stream().map(TmWareInfoEntity::getWareCode).collect(Collectors.toList());
        PriceParamVo priceParamVo = new PriceParamVo(productCodes, tmWareInfoVo.getPriceGroup(), tmWareInfoVo.getCustCode());
        ArrayList priceReturnVos1 = this.getCostPriceReturnVos(priceParamVo);
        priceReturnVos1 = priceReturnVos1 == null ? new ArrayList() : priceReturnVos1;
        priceReturnVos.addAll(priceReturnVos1);
        Map<String, String> mapPrice = priceReturnVos1.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, PriceWareReturnVo::getWareCode));
        for (int i = 0; i < productInfoEntities.size(); ++i) {
            if (!mapPrice.containsKey(((TmWareInfoEntity)productInfoEntities.get(i)).getWareCode())) continue;
            productInfoEntities.remove(i);
            --i;
        }
        return productInfoEntities;
    }

    @Override
    public PageInfo<TmWareInfoVo> findWarePriceSelfList(TmWareInfoPriceVo tmWareInfoPriceVo) {
        String custCode = tmWareInfoPriceVo.getCustCode();
        FindWarePriceVo findWarePriceVo = new FindWarePriceVo();
        findWarePriceVo.setCustCode(custCode);
        findWarePriceVo.setCodesIn(tmWareInfoPriceVo.getCodesIn());
        findWarePriceVo.setCodesNotIn(tmWareInfoPriceVo.getCodesNotIn());
        Page page = new Page();
        page.setPage(tmWareInfoPriceVo.getPage());
        page.setRows(tmWareInfoPriceVo.getRows());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findWarePriceSelfList(tmWareInfoPriceVo.getCodesIn(), tmWareInfoPriceVo.getCodesNotIn(), findWarePriceVo), (Page)page);
        PriceParamVo priceParamVo = new PriceParamVo();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            List codes = pageInfo.getList().stream().map(TmWareInfoVo::getWareCode).collect(Collectors.toList());
            priceParamVo.setProductCodes(codes);
            priceParamVo.setPriceDate(tmWareInfoPriceVo.getPriceDate());
            priceParamVo.setCustCode(custCode);
            List<PriceWareReturnVo> list = this.getStandPriceReturnVos(priceParamVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                Map<String, PriceWareReturnVo> map = list.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, item -> item));
                pageInfo.getList().forEach(item -> {
                    if (map.containsKey(item.getWareCode())) {
                        item.setPrice(((PriceWareReturnVo)map.get(item.getWareCode())).getPriceAmount());
                    }
                });
            }
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TmWareInfoVo> findWarePriceList(TmWareInfoPriceVo tmWareInfoPriceVo) {
        String custCode = tmWareInfoPriceVo.getCustCode();
        List<TmOrgEntity> orgEntities = this.orgService.findOrgListByCustcode(custCode);
        ArrayList<String> orgCodes = new ArrayList<String>();
        orgCodes.add("ALL");
        if (CollectionUtil.listNotEmptyNotSizeZero(orgEntities)) {
            orgEntities.forEach(item -> {
                List<TmOrgVo> orgVos = this.orgService.getOrgUpById(item.getId());
                if (CollectionUtil.listNotEmptyNotSizeZero(orgVos)) {
                    orgVos.forEach(temp -> orgCodes.add(temp.getOrgCode()));
                }
            });
        }
        orgCodes.stream().distinct();
        List<String> noBuyCodes = this.tmWareSalerangeDao.findWareNoBuyList(orgCodes, custCode);
        FindWarePriceVo findWarePriceVo = new FindWarePriceVo();
        findWarePriceVo.setCustCode(custCode);
        Page page = new Page();
        page.setPage(tmWareInfoPriceVo.getPage());
        page.setRows(tmWareInfoPriceVo.getRows());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findWarePriceList(noBuyCodes, orgCodes, findWarePriceVo), (Page)page);
        PriceParamVo priceParamVo = new PriceParamVo();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            List codes = pageInfo.getList().stream().map(TmWareInfoVo::getWareCode).collect(Collectors.toList());
            priceParamVo.setProductCodes(codes);
            priceParamVo.setPriceDate(tmWareInfoPriceVo.getPriceDate());
            priceParamVo.setCustCode(custCode);
            List<PriceWareReturnVo> list = this.getStandPriceReturnVos(priceParamVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                Map<String, PriceWareReturnVo> map = list.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, item -> item));
                pageInfo.getList().forEach(item -> {
                    if (map.containsKey(item.getWareCode())) {
                        item.setPrice(((PriceWareReturnVo)map.get(item.getWareCode())).getPriceAmount());
                    }
                });
            }
        }
        return pageInfo;
    }

    @Override
    public TmWareInfoEntity getTmWareInfoEntityByIdOrCode(String id, String code) {
        if (StringUtil.isNotBlank((CharSequence)id)) {
            return (TmWareInfoEntity)this.tmWareInfoDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotBlank((CharSequence)code)) {
            Example example = new Example(TmWareInfoEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("wareCode", (Object)code);
            List wareInfoEntities = this.tmWareInfoDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)wareInfoEntities)) {
                return (TmWareInfoEntity)wareInfoEntities.get(0);
            }
        }
        return null;
    }
}

