/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.dingtalk.service.impl;

import com.biz.eisp.activiti.DingtalkTodoFeign;
import com.biz.eisp.activiti.DingtalkUserFeign;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.dingtalk.dao.TmDingtalkUserBindingDao;
import com.biz.eisp.dingtalk.entity.TmDingtalkUserBindingEntity;
import com.biz.eisp.dingtalk.service.TmDingtalkUserBindingService;
import com.biz.eisp.mdm.dingtalk.vo.CreateTokenVo;
import com.biz.eisp.mdm.dingtalk.vo.TmDingtalkUserBindingVo;
import com.biz.eisp.registerToken.service.RegisterTokenApiService;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.tk.utils.BeanCopyUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
public class TmDingtalkUserBindingServiceImpl
implements TmDingtalkUserBindingService {
    private static final Logger log = LoggerFactory.getLogger(TmDingtalkUserBindingServiceImpl.class);
    @Autowired
    private TmDingtalkUserBindingDao tmDingtalkUserBindingDao;
    @Autowired
    private DingtalkUserFeign dingtalkUserFeign;
    @Autowired
    private RegisterTokenApiService registerTokenApiService;
    @Autowired
    private RedisService redisService;
    @Autowired
    private DingtalkTodoFeign dingtalkTodoFeign;

    @Override
    public AjaxJson<CreateTokenVo> createTokenByDingtalkCode(String dingtalkCode) {
        AjaxJson dingtalkUserIdObj = this.dingtalkUserFeign.getUserIdByDingtalkCode(dingtalkCode);
        if (!dingtalkUserIdObj.isSuccess()) {
            return dingtalkUserIdObj;
        }
        String dingtalkUserId = ((CreateTokenVo)dingtalkUserIdObj.getObj()).getDingtalkUserId();
        if (StringUtils.isBlank((CharSequence)dingtalkUserId)) {
            dingtalkUserIdObj.setErrMsg("\u83b7\u53d6\u9489\u9489\u7528\u6237ID\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            return dingtalkUserIdObj;
        }
        AjaxJson<TmDingtalkUserBindingVo> bindingVoAjaxJson = this.findByDingtalkUserId(dingtalkUserId);
        if (!bindingVoAjaxJson.isSuccess()) {
            bindingVoAjaxJson.setErrMsg(bindingVoAjaxJson.getMsg());
            return bindingVoAjaxJson;
        }
        TmDingtalkUserBindingVo bindingVo = (TmDingtalkUserBindingVo)bindingVoAjaxJson.getObj();
        if (null == bindingVo) {
            dingtalkUserIdObj.setErrMsg("no_binding");
            return dingtalkUserIdObj;
        }
        try {
            String key = this.registerTokenApiService.registerTokenNopas(bindingVo.getSysUserName(), 3600, Globals.LOGIN_SOURCE_DD);
            TmDingtalkUserBindingEntity entity = new TmDingtalkUserBindingEntity();
            entity.setSysUserId(bindingVo.getSysUserId());
            entity.setToken(key);
            this.updateBySysUserId(entity);
            ((CreateTokenVo)dingtalkUserIdObj.getObj()).setToken(key);
        }
        catch (BusinessException e) {
            dingtalkUserIdObj.setErrMsg(e.getMessage());
        }
        catch (Exception e) {
            dingtalkUserIdObj.setErrMsg("\u7cfb\u7edf\u5f02\u5e38");
        }
        return dingtalkUserIdObj;
    }

    @Override
    @Transactional
    public AjaxJson insertBatch(List<TmDingtalkUserBindingEntity> list) {
        AjaxJson ajaxJson = new AjaxJson();
        if (CollectionUtils.isEmpty(list)) {
            return ajaxJson;
        }
        String msg = this.checkInsertData(list);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setErrMsg(msg);
            return ajaxJson;
        }
        this.tmDingtalkUserBindingDao.insertList(list);
        return ajaxJson;
    }

    private String checkInsertData(List<TmDingtalkUserBindingEntity> list) {
        ArrayList sysUserNames = Lists.newArrayList();
        ArrayList dingtalkUserIds = Lists.newArrayList();
        for (TmDingtalkUserBindingEntity entity : list) {
            if (StringUtils.isBlank((CharSequence)entity.getDingtalkUserId())) {
                return "\u9489\u9489\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            if (StringUtils.isBlank((CharSequence)entity.getSysUserId())) {
                return "\u7cfb\u7edf\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            if (StringUtils.isBlank((CharSequence)entity.getSysUserName())) {
                return "\u7cfb\u7edf\u7528\u6237\u767b\u9646\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            sysUserNames.add(entity.getSysUserName());
            dingtalkUserIds.add(entity.getDingtalkUserId());
        }
        if (this.getListBySysUserNames(sysUserNames).getObjList().size() > 0) {
            return "\u7cfb\u7edf\u7528\u6237[" + (String)sysUserNames.get(0) + "]\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\u3002";
        }
        if (this.getListByDingtalkUserIds(dingtalkUserIds).getObjList().size() > 0) {
            return "\u9489\u9489\u7528\u6237[" + (String)dingtalkUserIds.get(0) + "]\u5df2\u5b58\u5728\u7ed1\u5b9a\u5173\u7cfb\u3002";
        }
        return null;
    }

    @Override
    @Transactional
    public AjaxJson updateByDingtalkUserId(TmDingtalkUserBindingEntity entity) {
        return null;
    }

    @Override
    @Transactional
    public AjaxJson updateBySysUserId(TmDingtalkUserBindingEntity entity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)entity.getSysUserId())) {
            ajaxJson.setErrMsg("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        Example example = new Example(TmDingtalkUserBindingEntity.class);
        example.and().andEqualTo("sysUserId", (Object)entity.getSysUserId());
        int updateCount = this.tmDingtalkUserBindingDao.updateByExampleSelective(entity, example);
        if (updateCount <= 0) {
            ajaxJson.setErrMsg("\u9489\u9489\u7528\u6237\u7ed1\u5b9a\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01");
            return ajaxJson;
        }
        return ajaxJson;
    }

    @Override
    @Transactional
    public AjaxJson deleteByDingtalkUserId(String dingtalkUserId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)dingtalkUserId)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setErrMsg("\u9489\u9489\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        Example param = new Example(TmDingtalkUserBindingEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("dingtalkUserId", (Object)dingtalkUserId);
        this.tmDingtalkUserBindingDao.deleteByExample(param);
        return ajaxJson;
    }

    @Override
    @Transactional
    public AjaxJson deleteBySysUserId(String sysUserId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)sysUserId)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setErrMsg("\u7cfb\u7edf\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return ajaxJson;
        }
        Example param = new Example(TmDingtalkUserBindingEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("sysUserId", (Object)sysUserId);
        this.tmDingtalkUserBindingDao.deleteByExample(param);
        return ajaxJson;
    }

    @Override
    public AjaxJson<TmDingtalkUserBindingVo> findByDingtalkUserId(String dingtalkUserId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)dingtalkUserId)) {
            return ajaxJson;
        }
        Example param = new Example(TmDingtalkUserBindingEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("dingtalkUserId", (Object)dingtalkUserId);
        List list = this.tmDingtalkUserBindingDao.selectByExample(param);
        if (list.size() == 0) {
            return ajaxJson;
        }
        if (list.size() > 1) {
            log.error("\u901a\u8fc7\u9489\u9489\u7528\u6237id\u67e5\u8be2\u7ed1\u5b9a\u6570\u636e\u5931\u8d25\uff0c\u67e5\u51fa\u591a\u6761\u91cd\u590d\u6570\u636e\u3002dingtalkUserId={}", (Object)dingtalkUserId);
            ajaxJson.setErrMsg("\u901a\u8fc7\u9489\u9489\u7528\u6237id\u67e5\u8be2\u7ed1\u5b9a\u6570\u636e\u5931\u8d25\uff0c\u67e5\u51fa\u591a\u6761\u91cd\u590d\u6570\u636e\u3002");
            ajaxJson.setSuccess(false);
            return ajaxJson;
        }
        ajaxJson.setObj(BeanCopyUtils.copyToBean(list.get(0), TmDingtalkUserBindingVo.class));
        return ajaxJson;
    }

    @Override
    public AjaxJson<TmDingtalkUserBindingVo> findBySysUserId(String sysUserId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtils.isBlank((CharSequence)sysUserId)) {
            return ajaxJson;
        }
        Example param = new Example(TmDingtalkUserBindingEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("sysUserId", (Object)sysUserId);
        List list = this.tmDingtalkUserBindingDao.selectByExample(param);
        if (list.size() == 0) {
            return ajaxJson;
        }
        if (list.size() > 1) {
            log.error("\u901a\u8fc7\u7cfb\u7edf\u7528\u6237id\u67e5\u8be2\u7ed1\u5b9a\u6570\u636e\u5931\u8d25\uff0c\u67e5\u51fa\u591a\u6761\u91cd\u590d\u6570\u636e\u3002sysUserId={}", (Object)sysUserId);
            ajaxJson.setErrMsg("\u901a\u8fc7\u7cfb\u7edf\u7528\u6237id\u67e5\u8be2\u7ed1\u5b9a\u6570\u636e\u5931\u8d25\uff0c\u67e5\u51fa\u591a\u6761\u91cd\u590d\u6570\u636e\u3002");
            ajaxJson.setSuccess(false);
            return ajaxJson;
        }
        ajaxJson.setObj(BeanCopyUtils.copyToBean(list.get(0), TmDingtalkUserBindingVo.class));
        return ajaxJson;
    }

    @Override
    public AjaxJson<TmDingtalkUserBindingVo> getListBySysUserNames(List<String> sysUserNames) {
        AjaxJson ajaxJson = new AjaxJson();
        if (CollectionUtils.isEmpty(sysUserNames)) {
            return ajaxJson;
        }
        Example param = new Example(TmDingtalkUserBindingEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andIn("sysUserName", sysUserNames);
        List list = this.tmDingtalkUserBindingDao.selectByExample(param);
        ajaxJson.setObjList(BeanCopyUtils.copyToBeanList((List)list, TmDingtalkUserBindingVo.class));
        return ajaxJson;
    }

    @Override
    public AjaxJson<TmDingtalkUserBindingVo> getListByDingtalkUserIds(List<String> dingtalkUserIds) {
        AjaxJson ajaxJson = new AjaxJson();
        if (CollectionUtils.isEmpty(dingtalkUserIds)) {
            return ajaxJson;
        }
        Example param = new Example(TmDingtalkUserBindingEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andIn("dingtalkUserId", dingtalkUserIds);
        List list = this.tmDingtalkUserBindingDao.selectByExample(param);
        ajaxJson.setObjList(BeanCopyUtils.copyToBeanList((List)list, TmDingtalkUserBindingVo.class));
        return ajaxJson;
    }

    @Override
    public AjaxJson unbindDingtalkByUserName(String userName) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)userName)) {
            ajaxJson.setErrMsg("\u7a7a\u7528\u6237\u540d!");
            return ajaxJson;
        }
        Example param = new Example(TmDingtalkUserBindingEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andEqualTo("sysUserName", (Object)userName);
        List bindingEntities = this.tmDingtalkUserBindingDao.selectByExample(param);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)bindingEntities)) {
            for (TmDingtalkUserBindingEntity item : bindingEntities) {
                this.dingtalkTodoFeign.delByDingtalkUserId(item.getDingtalkUserId());
                String redisKey = "LOGIN_SUCCESS_" + item.getToken();
                this.redisService.del(new String[]{redisKey});
                this.tmDingtalkUserBindingDao.deleteByPrimaryKey(item.getId());
            }
        } else {
            ajaxJson.setErrMsg("\u8be5\u7528\u6237\u8fd8\u672a\u7ed1\u5b9a\u9489\u9489\u8d26\u53f7\u3002");
        }
        return ajaxJson;
    }
}

