/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.org.redis.service;

import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.org.redis.vo.RedisOrgVo;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.service.RedisService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgRedisService {
    @Autowired
    private RedisService redisService;
    @Autowired
    private OrgService orgService;

    public String getVsersionKey() {
        Object o = this.redisService.get("mdm_global_org_version");
        if (o == null) {
            return this.setVsersionKey();
        }
        return o.toString();
    }

    public String setVsersionKey() {
        String version = UUID.randomUUID().toString().replaceAll("-", "");
        this.redisService.setDays("mdm_global_org_version", (Object)version, 365L);
        return version;
    }

    public List<RedisOrgVo> getAllOrgByRedis() {
        String version = this.getVsersionKey();
        String key = "mdm_global_org_" + version;
        Object o = this.redisService.get(key);
        if (o != null) {
            return (List)o;
        }
        return null;
    }

    public List<RedisOrgVo> setAllOrgByRedis() {
        List<TmOrgEntity> tmOrgEntities = this.orgService.getOrgListAll(ConstantEnum.StatusEnum.NEW.getValue(), ConstantEnum.StatusEnum.NEW.getValue());
        ArrayList<RedisOrgVo> redisOrgVos = new ArrayList<RedisOrgVo>();
        for (TmOrgEntity item : tmOrgEntities) {
            RedisOrgVo redisOrgVo = new RedisOrgVo();
            BeanUtils.copyProperties((Object)item, (Object)redisOrgVo);
            redisOrgVos.add(redisOrgVo);
        }
        String version = this.getVsersionKey();
        this.redisService.lSet("mdm_global_org_", redisOrgVos, 2592000L);
        return redisOrgVos;
    }
}

