/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.terminalCusPos.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.kernel.KnlCodeRuleFeign;
import com.biz.eisp.terminal.TmRTermCustPosBGEntity;
import com.biz.eisp.terminalCusPos.dao.TerminalCusPosDao;
import com.biz.eisp.terminalCusPos.service.TmRTermCustPosBgService;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(readOnly=true)
public class TmRTermCustPosBgServiceImpl
implements TmRTermCustPosBgService {
    @Autowired
    private KnlCodeRuleFeign knlCodeRuleFeign;
    @Resource
    private TerminalCusPosDao terminalCusPosDao;

    @Override
    @Transactional
    public AjaxJson<TmRTermCustPosBGEntity> insertButch(List<TmRTermCustPosBGEntity> list) {
        AjaxJson results = new AjaxJson();
        if (CollectionUtils.isEmpty(list)) {
            return results;
        }
        List codes = this.knlCodeRuleFeign.getCodeRuleList("business_group", Integer.valueOf(list.size())).getObjList();
        if (CollectionUtils.isEmpty((Collection)codes) || codes.size() != list.size()) {
            results.setErrMsg("\u83b7\u53d6\u4e1a\u52a1\u7ec4\u7f16\u7801\u5931\u8d25\uff01");
            results.setSuccess(false);
            return results;
        }
        for (int i = 0; i < list.size(); ++i) {
            TmRTermCustPosBGEntity entity = list.get(i);
            entity.setBusinessGroup((String)codes.get(i));
        }
        this.terminalCusPosDao.insertList(list);
        results.setObjList(list);
        return results;
    }

    @Override
    public Map<String, List<TmRTermCustPosBGEntity>> getByTerminalIds(Set<String> terminalIds) {
        if (CollectionUtils.isEmpty(terminalIds)) {
            return Maps.newHashMap();
        }
        Example param = new Example(TmRTermCustPosBGEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andIn("terminalId", terminalIds);
        return this.terminalCusPosDao.selectByExample(param).stream().collect(Collectors.groupingBy(TmRTermCustPosBGEntity::getCustomerId));
    }

    @Override
    public Map<String, Set<String>> getPosiIdsByTerminalIds(Set<String> terminalIds) {
        if (CollectionUtils.isEmpty(terminalIds)) {
            return Maps.newHashMap();
        }
        Example param = new Example(TmRTermCustPosBGEntity.class);
        Example.Criteria builder = param.createCriteria();
        builder.andIn("terminalId", terminalIds);
        return this.terminalCusPosDao.selectByExample(param).stream().collect(Collectors.groupingBy(TmRTermCustPosBGEntity::getTerminalId, Collectors.mapping(TmRTermCustPosBGEntity::getPositionId, Collectors.toSet())));
    }
}

