/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.base.global;

import com.biz.primus.base.global.GlobalParams;
import com.biz.primus.base.global.GlobalValue;
import com.biz.primus.base.global.Ref;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class GlobalRefHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalRefHandler.class);
    private static final Set<Class> ignoreClasses = Sets.newHashSet();
    private static final LoadingCache<Class, List<Pair<Field, GlobalValue>>> CACHE = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Class, List<Pair<Field, GlobalValue>>>(){

        public List<Pair<Field, GlobalValue>> load(Class clazz) throws Exception {
            List fields = FieldUtils.getFieldsListWithAnnotation((Class)clazz, Ref.class);
            return fields.stream().map(f -> Pair.of((Object)f, (Object)((Object)f.getAnnotation(Ref.class).value()))).collect(Collectors.toList());
        }
    });

    private GlobalRefHandler() {
    }

    public static void handle(GlobalParams gp, Object target) {
        List pairs;
        if (target == null) {
            return;
        }
        Class<?> clazz = target.getClass();
        if (ignoreClasses.contains(clazz)) {
            return;
        }
        try {
            pairs = (List)CACHE.get(clazz);
        }
        catch (ExecutionException e) {
            log.info("exception msg :{}", (Object)e.getMessage());
            throw new RuntimeException("\u53cd\u5c04\u5f15\u7528\u5168\u5c40\u53c2\u6570\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
        if (CollectionUtils.isEmpty((Collection)pairs)) {
            ignoreClasses.add(clazz);
            return;
        }
        pairs.forEach(p -> {
            ReflectionUtils.makeAccessible((Field)((Field)p.getKey()));
            ReflectionUtils.setField((Field)((Field)p.getKey()), (Object)target, (Object)GlobalRefHandler.getGlobalParam(gp, (GlobalValue)((Object)((Object)p.getValue()))));
        });
    }

    private static Object getGlobalParam(GlobalParams gp, GlobalValue gv) {
        switch (gv) {
            case userId: {
                return gp.getUserId();
            }
            case globalParams: {
                return gp;
            }
            case os: {
                return gp.getOs();
            }
            case ver: {
                return gp.getVer();
            }
            case ip: {
                return gp.getIp();
            }
        }
        throw new RuntimeException("\u9519\u8bef\u7684\u4ee3\u7801:\u6ca1\u6709\u5bf9GlobalValue[" + (Object)((Object)gv) + "]\u505a\u6620\u5c04");
    }
}

