/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.base.util;

import com.biz.primus.base.annotation.ExcelColumn;
import com.biz.primus.base.annotation.ExcelColumnDataFormat;
import com.biz.primus.base.annotation.ExcelDataColumn;
import com.biz.primus.base.annotation.ExcelSheetName;
import com.biz.primus.base.exception.GlobalExceptionType;
import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.google.common.collect.Lists;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExportUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportUtil.class);

    private ExcelExportUtil() {
    }

    public static ExcelExportUtil newInstance() {
        return ExcelExportUtilHolder.instance;
    }

    public void exportVoTranBook(List<?> exportVos, Workbook templateBook) throws Exception {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(exportVos), (ExceptionType)GlobalExceptionType.PARAM_ERROR, (String)"\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\uff01");
        Class<?> classVo = exportVos.get(0).getClass();
        this.buildWorkbook(exportVos, classVo, templateBook);
    }

    private void buildWorkbook(List<?> exportVos, Class<?> classVo, Workbook templateBook) throws Exception {
        List<Field> annotationFields = this.getAnnotationFields(classVo);
        this.buildSheet(annotationFields, exportVos, classVo, templateBook);
    }

    private List<Field> getAnnotationFields(Class<?> classVo) {
        Field[] fields = classVo.getDeclaredFields();
        ArrayList<Field> annotationFields = new ArrayList<Field>();
        for (Field field : fields) {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            if (excelColumn == null) continue;
            annotationFields.add(field);
        }
        return annotationFields;
    }

    private void buildSheet(List<Field> annotationFields, List<?> exportVos, Class<?> classVo, Workbook templateBook) throws Exception {
        Sheet sheet = templateBook.getSheetAt(0);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(annotationFields), (ExceptionType)GlobalExceptionType.PARAM_ERROR, (String)"\u6ca1\u6709\u53ef\u63a5\u6536\u6570\u636e\u7684\u5b57\u6bb5");
        ExcelDataColumn excelDataColumn = classVo.getAnnotation(ExcelDataColumn.class);
        AssertUtils.isTrue((excelDataColumn != null && excelDataColumn.dataNumber() >= 1 ? 1 : 0) != 0, (ExceptionType)GlobalExceptionType.PARAM_ERROR, (String)"\u6570\u636e\u884c\u53f7\u6ce8\u89e3\u4e3a\u7a7a");
        int dataNumber = excelDataColumn.dataNumber();
        for (int rowNum = 0; rowNum < exportVos.size(); ++rowNum) {
            Row rowAnother = sheet.createRow(rowNum + dataNumber);
            for (int dataCellNum = 0; dataCellNum < annotationFields.size(); ++dataCellNum) {
                Field annotationField = annotationFields.get(dataCellNum);
                PropertyDescriptor pd = new PropertyDescriptor(annotationField.getName(), classVo);
                Method method = pd.getReadMethod();
                Object object = method.invoke(exportVos.get(rowNum), new Object[0]);
                ExcelColumn excelColumn = annotationField.getAnnotation(ExcelColumn.class);
                Class aClass = excelColumn.dataClass();
                ExcelColumnDataFormat dataFormat = annotationField.getAnnotation(ExcelColumnDataFormat.class);
                Cell cell = rowAnother.createCell(dataCellNum);
                if (dataFormat != null && StringUtils.isNotBlank((CharSequence)dataFormat.dataFormat())) {
                    CellStyle style = templateBook.createCellStyle();
                    DataFormat format = templateBook.createDataFormat();
                    style.setDataFormat(format.getFormat(dataFormat.dataFormat()));
                    cell.setCellStyle(style);
                }
                if (aClass == Integer.class || aClass == Double.class) {
                    cell.setCellValue(((Double)object).doubleValue());
                    continue;
                }
                cell.setCellValue(object == null ? "" : object.toString());
            }
        }
        sheet.setForceFormulaRecalculation(true);
    }

    public <T> List<T> bookTranExportVos(Workbook workbook, Class<T> classVo) throws Exception {
        ArrayList listObject = Lists.newArrayList();
        ExcelDataColumn excelDataColumn = classVo.getAnnotation(ExcelDataColumn.class);
        AssertUtils.isTrue((excelDataColumn != null && excelDataColumn.dataNumber() >= 1 ? 1 : 0) != 0, (ExceptionType)GlobalExceptionType.PARAM_ERROR, (String)"\u6570\u636e\u884c\u53f7\u6ce8\u89e3\u4e3a\u7a7a");
        ExcelSheetName excelSheetName = classVo.getAnnotation(ExcelSheetName.class);
        Sheet sheet = excelSheetName == null || "".equals(excelSheetName.name()) ? workbook.getSheetAt(0) : workbook.getSheet(excelSheetName.name());
        Object[] fields = classVo.getDeclaredFields();
        AssertUtils.isTrue((fields != null && fields.length > 0 ? 1 : 0) != 0, (ExceptionType)GlobalExceptionType.PARAM_ERROR, (String)"\u6ca1\u6709\u53ef\u63a5\u6536\u6570\u636e\u7684\u884c\u6ce8\u89e3");
        List canReceiveDataFeilds = Lists.newArrayList((Object[])fields).stream().filter(field -> field.getAnnotation(ExcelColumn.class) != null).collect(Collectors.toList());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(canReceiveDataFeilds), (ExceptionType)GlobalExceptionType.PARAM_ERROR, (String)"\u6ca1\u6709\u53ef\u63a5\u6536\u6570\u636e\u7684\u5b57\u6bb5");
        for (int rowIndex = 0; rowIndex < sheet.getPhysicalNumberOfRows(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex + excelDataColumn.dataNumber());
            if (row == null) continue;
            T obj = classVo.newInstance();
            for (int cellIndex = 0; cellIndex < canReceiveDataFeilds.size(); ++cellIndex) {
                AssertUtils.isTrue((cellIndex <= canReceiveDataFeilds.size() - 1 ? 1 : 0) != 0, (ExceptionType)GlobalExceptionType.PARAM_ERROR, (String)"\u6570\u636e\u5217\u8d85\u51fa\u63a5\u6536\u8303\u56f4");
                Field field2 = (Field)canReceiveDataFeilds.get(cellIndex);
                ExcelColumn excelColumn = field2.getAnnotation(ExcelColumn.class);
                PropertyDescriptor pd = new PropertyDescriptor(field2.getName(), classVo);
                Cell cell = row.getCell(cellIndex);
                if (cell == null) continue;
                Method method = pd.getWriteMethod();
                Class aClass = excelColumn.dataClass();
                if (aClass == Integer.class) {
                    cell.setCellType(0);
                    method.invoke(obj, Double.valueOf(cell.getNumericCellValue()).intValue());
                    continue;
                }
                if (aClass == Double.class) {
                    cell.setCellType(0);
                    method.invoke(obj, cell.getNumericCellValue());
                    continue;
                }
                cell.setCellType(1);
                method.invoke(obj, cell.getStringCellValue());
            }
            listObject.add(obj);
        }
        return listObject;
    }

    private static class ExcelExportUtilHolder {
        static ExcelExportUtil instance = new ExcelExportUtil();

        private ExcelExportUtilHolder() {
        }
    }
}

