/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.base.vo;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Sort;

public class Sortable
implements Serializable {
    private List<Order> orders;

    public Sortable(Order order) {
        ArrayList<Order> list = new ArrayList<Order>();
        list.add(order);
        this.orders = list;
    }

    public Sort toSort() {
        return new Sort(this.orders.stream().map(in -> new Sort.Order(in.getDirection().toSpringDirection(), in.getProperty())).collect(Collectors.toList()));
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sortable)) {
            return false;
        }
        Sortable other = (Sortable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Order> this$orders = this.getOrders();
        List<Order> other$orders = other.getOrders();
        return !(this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sortable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Order> $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
        return result;
    }

    public String toString() {
        return "Sortable(orders=" + this.getOrders() + ")";
    }

    @ConstructorProperties(value={"orders"})
    public Sortable(List<Order> orders) {
        this.orders = orders;
    }

    public static class Order
    implements Serializable {
        private Direction direction;
        private String property;

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Order)) {
                return false;
            }
            Order other = (Order)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Direction this$direction = this.getDirection();
            Direction other$direction = other.getDirection();
            if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !this$property.equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Order;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Direction $direction = this.getDirection();
            result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            return result;
        }

        public String toString() {
            return "Sortable.Order(direction=" + (Object)((Object)this.getDirection()) + ", property=" + this.getProperty() + ")";
        }

        @ConstructorProperties(value={"direction", "property"})
        public Order(Direction direction, String property) {
            this.direction = direction;
            this.property = property;
        }
    }

    public static enum Direction {
        ASC,
        DESC;


        public Sort.Direction toSpringDirection() {
            if (this == ASC) {
                return Sort.Direction.ASC;
            }
            return Sort.Direction.DESC;
        }
    }
}

