/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.base.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class LongToTwoBitBigDecimalStringSerializer
extends JsonSerializer<Long> {
    private static final DecimalFormat FORMAT = new DecimalFormat("#,##0.00");

    public void serialize(Long aLong, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        if (aLong != null) {
            BigDecimal amount = new BigDecimal(aLong).divide(new BigDecimal(10000.0));
            String format = FORMAT.format(amount);
            jsonGenerator.writeString(format);
        } else {
            jsonGenerator.writeString("");
        }
    }
}

