/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.base.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static final String EMAIL_REG = "^(\\w)+(\\.\\w+)*@(\\w)+((\\.\\w+)+)$";
    private static final String NEW_MOBILE_REG = "^1\\d{10}$";
    private static final String PWD_PATTERN = "^([A-Z]|[a-z]|[0-9]){8}$";

    private StringUtil() {
    }

    public static boolean isNumberChar(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isUppercase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowercase(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static boolean isSpecialChar(char c) {
        return !StringUtil.isLetter(c) && !StringUtil.isNumberChar(c) && !StringUtil.isChinese(c);
    }

    public static String byte2fex(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    public static boolean isMobile(String mobile) {
        return StringUtils.isNotBlank((CharSequence)mobile) && mobile.matches(NEW_MOBILE_REG);
    }

    public static boolean isPwdPattern(String pwd) {
        return StringUtils.isNotBlank((CharSequence)pwd) && pwd.matches(PWD_PATTERN);
    }

    public static int getByteLength(String s) {
        if (s == null) {
            return 0;
        }
        s = s.replaceAll("[^\\x00-\\xff]", "**");
        int length = s.length();
        return length;
    }

    public static void blankFill(String[] chars, String fill) {
        if (chars == null || chars.length == 0) {
            return;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (!StringUtils.isBlank((CharSequence)chars[i])) continue;
            chars[i] = fill;
        }
    }

    public static String filterInvalidChars(String str, String regex) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        String content = new String(str);
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        String result = m.replaceAll("");
        return result;
    }

    public static String mist(String conent) {
        if (StringUtils.isBlank((CharSequence)conent)) {
            return "*";
        }
        String mistedStr = String.valueOf(conent.charAt(0));
        mistedStr = mistedStr + (conent.length() > 3 ? "**" + conent.charAt(conent.length() - 1) : (conent.length() > 2 ? "*" + conent.charAt(conent.length() - 1) : "*"));
        return mistedStr;
    }

    public static String patternMatcherStr(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',//[//].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isEmail(String str) {
        return StringUtils.isNotBlank((CharSequence)str) && str.matches(EMAIL_REG);
    }

    public static String getVersionTs() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String ts = format.format(new Date());
        return ts;
    }

    public static String hump2Underline(String str) {
        String regex = "([a-z])([A-Z])";
        String replacement = "$1_$2";
        return str.replaceAll(regex, replacement).toLowerCase();
    }
}

