/**
 * @Description: 
 * @ClassName: com.biz.oms.OmsOrderApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年4月8日 上午11:35:13 
 */
package com.biz.oms.service;

/**
 * OMS 
 * 订单接口
 * @Description: 
 * @ClassName: com.biz.oms.OmsOrderApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年4月8日 上午11:35:13 
 *
 */
public interface OmsOrderApiService {

	/**
	 * 接收普通订单并加入到MQ中
	 * @Title: mqJoinOrder 
	 * @param orderJson 订单json
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年2月26日 上午9:46:11
	 */
	public Boolean mqJoinOrder(String orderJson);

	/**
	 * 接收订单并加入MQ中
	 * @Title: mqJoinOrder 
	 * @param orderJson 订单JSON
	 * @param isRightNowOrder 是否是立即送订单
	 * @return 
	 * @author: Omar(OmarZhang)
	 * @date: 2016年4月8日 上午11:20:16
	 */
	Boolean mqJoinOrder(String orderJson, Boolean isRightNowOrder);
}
