/**
 * @Description: 
 * @ClassName: com.biz.orderDocker.zk.ZookeeperLoadIterceptorRules
 * @author: Omar(OmarZhang)
 * @date: 2016年8月5日 下午11:17:02 
 */
package com.biz.oms.utils;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCache.StartMode;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.data.Stat;

/**
 * zookeeper 客户端
 * @Description:
 * @ClassName: com.biz.orderDocker.zk.ZookeeperLoadIterceptorRules
 * @author: Omar(OmarZhang)
 * @date: 2016年8月5日 下午11:17:02
 *
 */
public abstract class ZookeeperClientUtils {

	private static String ZKURL = "127.0.0.1";
	private final static String  TEMPDEFATULNODEPARENTPATH= "/cpmachine";
	private final static String  TEMPDEFATULNODEPATH= "/cpmachine/limitmq";
	private  String DEFATULNODEPARENTPATH = TEMPDEFATULNODEPARENTPATH;
	private  String DEFATULNODEPATH = TEMPDEFATULNODEPATH;

	private CuratorFramework curatorFramework = null;

	private CuratorFramework getClient() {
		CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(ZKURL)
				.sessionTimeoutMs(5000).connectionTimeoutMs(3000).retryPolicy(new ExponentialBackoffRetry(1000, 3))
				.build();
		return curatorFramework;
	}
	
	/**
	 * 初始
	 * @Title: readData 
	 * @param zkUrl zk 地址 默认节点地址: /cpmachine/limitmq, 默认父节点 /cpmachine
	 * @param nodePath 节点路径 eg: /oms/zk/interceptor/interceptorPath
	 * @param nodeParentPath 父节点路径 eg: /oms/zk/interceptor
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年8月19日 下午2:59:42
	 */
	public void init(String url,String nodePath,String nodeParentPath) {
		ZKURL = url;
		DEFATULNODEPARENTPATH = nodeParentPath;
		DEFATULNODEPATH = nodePath;
		watchChangeData();
		
	}
	
	
	/**
	 * 初始
	 * 自动监听节点变化
	 * @Title: readData 
	 * @param zkUrl zk 地址 默认节点为服务节点 请勿乱用
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年8月19日 下午2:59:42
	 */
	public void init(String url) {
		ZKURL = url;
		DEFATULNODEPARENTPATH = TEMPDEFATULNODEPARENTPATH;
		DEFATULNODEPATH = TEMPDEFATULNODEPATH;
		watchChangeData();
	}
	
	/**
	 * 读取节点信息 需要手动读取
	 *  <pre>
	 *	final List<String> bodyTemps = new ArrayList<String>();
	 *  new ZookeeperClientUtils() {
	 *  public void readData(byte[] bytes) {
	 *  String body = StringUtils.newStringUtf8(bytes);
	 *	if(body != null && !"".equals(body)) {
	 *		bodyTemps.add(body);
	 *	  }
	 *	 }
	 *  }.getInit(zookeeperUrl);
	 * </pre>
	 * @Title: getInit 
	 * @param url
	 * @author: Omar(OmarZhang)
	 * @date: 2016年8月20日 下午7:13:02
	 */
	public void getInit(String url) {
		try {
			ZKURL = url;
			DEFATULNODEPARENTPATH = TEMPDEFATULNODEPARENTPATH;
			DEFATULNODEPATH = TEMPDEFATULNODEPATH;
			curatorFramework = getClient();
			curatorFramework.start();
			Stat stat = curatorFramework.checkExists().forPath(DEFATULNODEPATH);
			if (stat == null) {
				curatorFramework.create().creatingParentsIfNeeded().forPath(DEFATULNODEPATH,new byte[]{});
			}
			byte[] bytes = curatorFramework.getData().forPath(DEFATULNODEPATH);
			readData(bytes);
		} catch (Exception e) {
			e.printStackTrace();
		}finally {
			curatorFramework.close();
		}
	}
	

	/**
	 * 监听 订单拦截规则
	 * 
	 * @Title: watchChangeData
	 * @author: Omar(OmarZhang)
	 * @date: 2016年8月5日 下午11:28:05
	 */
	@SuppressWarnings("resource")
	private void watchChangeData() {
		try {
			curatorFramework = getClient();
			curatorFramework.start();
			Stat stat = curatorFramework.checkExists().forPath(DEFATULNODEPATH);
			if (stat == null) {
				curatorFramework.create().creatingParentsIfNeeded().forPath(DEFATULNODEPATH,new byte[]{});
			}
			PathChildrenCache pathChildrenCache = new PathChildrenCache(curatorFramework, DEFATULNODEPARENTPATH,true);
			pathChildrenCache.start(StartMode.POST_INITIALIZED_EVENT);
			PathChildrenCacheListener childrenCacheListener = new PathChildrenCacheListener() {
				@Override
				public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
					ChildData data = event.getData();
					byte[] bytes = {};
					if(data != null) {
						bytes = data.getData();
					} 
					switch (event.getType()) {
					case CHILD_ADDED:
						readData(bytes);
						break;
					case CHILD_REMOVED:
						readData(bytes);
						break;
					case CHILD_UPDATED:
						readData(bytes);
						break;
					default:
						break;
					}
				}
			};
			pathChildrenCache.getListenable().addListener(childrenCacheListener);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 读取数据
	 * @Title: readData 
	 * @param zkUrl zk 地址
	 * @param nodePath 节点路径 eg: /oms/zk/interceptor/interceptorPath
	 * @param nodeParentPath 父节点路径 eg: /oms/zk/interceptor
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年8月19日 下午2:59:42
	 */
	public abstract void readData(byte[] bytes);
	
}
