/**
 * @Description: 
 * @ClassName: com.biz.orderDocker.vo.OrderItemVo
 * @author: Omar(OmarZhang)
 * @date: 2016年2月29日 下午2:30:22 
 */
package com.biz.oms.parseVo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 订单项Vo
 * @Description: 
 * @ClassName: com.biz.orderDocker.vo.OrderItemVo
 * @author: Omar(OmarZhang)
 * @date: 2016年2月29日 下午2:30:22 
 *
 */
public class OrderItemVo implements Serializable{

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 1L;
	
	/** 商品编号*/
	private String bn;
	/** 商品名称*/
	private String name;
	/** 商品数量*/
	private Integer quantity;
	/** 商品原价*/
	private BigDecimal price;
	/** 商品总价*/
	private BigDecimal amount;
	/** 商品重量*/
	private BigDecimal weight = BigDecimal.ZERO;
	/** 商品购买价格*/
	private BigDecimal g_price;
	/** 商品/赠品*/
	private String productType;
	/** 是否属于自身维护编号,
	 *  如果为true 则表示该编号是自身维护 需要从数据库中
	 *  根据短编号进行查询获取
	 * */
	private Boolean isOwnBn;
	/** 拆分之后的商品组合信息*/
	private List<ProductInfoVo> splitProducts = new ArrayList<ProductInfoVo>();
	
	
	/**
	 * @return the bn
	 */
	public String getBn() {
		return bn;
	}
	/**
	 * @param bn the bn to set
	 */
	public void setBn(String bn) {
		this.bn = bn;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the quantity
	 */
	public Integer getQuantity() {
		return quantity;
	}
	/**
	 * @param quantity the quantity to set
	 */
	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}
	/**
	 * @return the price
	 */
	public BigDecimal getPrice() {
		return price;
	}
	/**
	 * @param price the price to set
	 */
	public void setPrice(BigDecimal price) {
		this.price = price;
	}
	/**
	 * @return the amount
	 */
	public BigDecimal getAmount() {
		return amount;
	}
	/**
	 * @param amount the amount to set
	 */
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
	/**
	 * @return the weight
	 */
	public BigDecimal getWeight() {
		return weight;
	}
	/**
	 * @param weight the weight to set
	 */
	public void setWeight(BigDecimal weight) {
		this.weight = weight;
	}
	/**
	 * @return the g_price
	 */
	public BigDecimal getG_price() {
		return g_price;
	}
	/**
	 * @param g_price the g_price to set
	 */
	public void setG_price(BigDecimal g_price) {
		this.g_price = g_price;
	}
	/**
	 * @return the productType
	 */
	public String getProductType() {
		return productType;
	}
	/**
	 * @param productType the productType to set
	 */
	public void setProductType(String productType) {
		this.productType = productType;
	}
	/**
	 * @return the isOwnBn
	 */
	public Boolean getIsOwnBn() {
		return isOwnBn;
	}
	/**
	 * @param isOwnBn the isOwnBn to set
	 */
	public void setIsOwnBn(Boolean isOwnBn) {
		this.isOwnBn = isOwnBn;
	}
	/**
	 * @return the splitProducts
	 */
	public List<ProductInfoVo> getSplitProducts() {
		return splitProducts;
	}
	/**
	 * @param splitProducts the splitProducts to set
	 */
	public void setSplitProducts(List<ProductInfoVo> splitProducts) {
		this.splitProducts = splitProducts;
	}
	
}
