package com.biz.oms.parseVo.reportVo;


import java.io.Serializable;

/**
 * @Description: 报备订单接收对象
 * @Author: AverageJoe
 * @Date: 2017/7/14 14:57
 */
public class OrderReport implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer id;

    /**
     * 订单编号
     */
    private String orderBn;



    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 订单在中台的状态
     */
    private String orderStatus;

    /**
     * 报备类型
     */
    private String reportType;

    /**
     * 报备时间
     */
    private String reportTime;

    /**
     * 门店编号
     */
    private String storeNo;

    /**
     * 门店名称
     */
    private String storeName;


    /**
     * 处理状态 0未处理,1处理中,2,处理完成
     */
    private Short status;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 处理人
     */
    private String handler;

    /**
     * 处理时间
     */
    private String handleTime;
    /**
     * 配送优先级
     */
    private int shippingOrder;

    public int getShippingOrder() {
        return shippingOrder;
    }

    public void setShippingOrder(int shippingOrder) {
        this.shippingOrder = shippingOrder;
    }




    public String getOrderSource() {
        return orderSource;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public String getReportTime() {
        return reportTime;
    }

    public void setReportTime(String reportTime) {
        this.reportTime = reportTime;
    }

    public String getHandleTime() {
        return handleTime;
    }

    public void setHandleTime(String handleTime) {
        this.handleTime = handleTime;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getOrderBn() {
        return orderBn;
    }

    public void setOrderBn(String orderBn) {
        this.orderBn = orderBn == null ? null : orderBn.trim();
    }


    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus == null ? null : orderStatus.trim();
    }

    public String getReportType() {
        return reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType == null ? null : reportType.trim();
    }


    public String getStoreNo() {
        return storeNo;
    }

    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo == null ? null : storeNo.trim();
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName == null ? null : storeName.trim();
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public String getHandler() {
        return handler;
    }

    public void setHandler(String handler) {
        this.handler = handler == null ? null : handler.trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", orderBn=").append(orderBn);
        sb.append(", shopBn=").append(orderBn);
        sb.append(", orderStatus=").append(orderStatus);
        sb.append(", reportType=").append(reportType);
        sb.append(", reportTime=").append(reportTime);
        sb.append(", storeNo=").append(storeNo);
        sb.append(", storeName=").append(storeName);
        sb.append(", status=").append(status);
        sb.append(", remarks=").append(remarks);
        sb.append(", handler=").append(handler);
        sb.append(", handleTime=").append(handleTime);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}