/**
 * @Description:
 * @ClassName: com.biz.orderDocker.parseVo.OrderBaseVo
 * @author: Omar(OmarZhang)
 * @date: 2016年4月12日 下午3:04:28 
 */
package com.biz.oms.parseVo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 订单基本信息
 * @Description:
 * @ClassName: com.biz.orderDocker.parseVo.OrderBaseVo
 * @author: Omar(OmarZhang)
 * @date: 2016年4月12日 下午3:04:28
 *
 */
public class OrderBaseVo implements Serializable{

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 1L;

	private Integer id;
	/** 订单来源*/
	private String ordersource;
	/** 来自节点ID*/
	private String to_node_id;
	/** 店铺编码*/
	private String shopBn;
	/** 订单类型: normal,sale,aftersale 默认为 normal*/
	private String orderType = "normal";
	/** 订单编号*/
	private String order_bn;
	/** 商品花费金额*/
	private BigDecimal cost_item;
	/** 税费（需要发票时）*/
	private BigDecimal cost_tax;
	/** 订单创建时间*/
	private Date createtime;
	/** 订单总价 */
	private BigDecimal cur_amount;
	/** 货币类型*/
	private String currency;
	/** 客户备注*/
	private String custom_mark;
	/** 折让 大于0则表示减去，小于0则表示增加*/
	private Integer discount;
	/** 是否需要发票*/
	private Boolean is_tax;
	/** 发票类型  普通发票/增值税发票 */
	private String invoiceType;
	/** 发票抬头*/
	private String invoiceTitle;
	/** 发票内容*/
	private String invoiceDetails;
	/** 是否纸质发票*/
	private Boolean isPaperInvoice;
	/** 最后修改时间*/
	private Date lastmodify;
	/** 订单下单/生成日期*/
	private Date modified;
	/** 订单项*/
	private List<OrderItemVo> order_items = new ArrayList<OrderItemVo>();
	/** 支付方式 */
	private String pay_bn;
	/** 支付状态*/
	private Integer pay_status;
	/** 已支付金额 */
	private BigDecimal payed;
	/** 支付信息*/
	private PayInfoVo payinfo = new PayInfoVo();
	/** 商品优惠描述*/
	private List<PmtDetail> pmt_detail = new ArrayList<PmtDetail>();
	/** 订单优惠金额*/
	private BigDecimal pmt_order;
	/** 商品优惠*/
	private BigDecimal pmt_goods;
	/** 平台优惠*/
	private BigDecimal pmt_plateform;
	/** 配送状态*/
	private Integer ship_status;
	/** 配送信息*/
	private ShippingVo shipping = new ShippingVo();
	/** 订单状态*/
	private String status;
	/** 订单总金额*/
	private BigDecimal total_amount;
	/** 收货人信息*/
	private ConsigneeVo consignee = new ConsigneeVo();
	/** 门店编号*/
	private String storeNo;
	/** false: 自动分单 true : 人工分单*/
	private Boolean isPumpSplit;
	/** 配送优先级 1: 立即送  2: 普通送 3:自提*/
	private Integer shippingOrder;
	/** 是否改派过*/
	private Boolean isHasDelivery ;
	/**配送单版本号*/
	private Integer deliveryVersion;
	/**下单渠道*/
	private String channelsOrder;
	/**会员名*/
	private String members_name;
	/**作息工号*/
	private String work_routine;
	/**会员电话*/
	private String members_phone;
	/**门店名称*/
	private String storeName;
	/** 会员账号*/
	private String memberAccount;
	/** 会员等级*/
	private Integer memberLevel;
	/** 卖家备注*/
	private String sellerMark;
	/** 送达时间*/
	private Date sendingTime;
	/** 最新改派时间*/
	private Date lastModifyDeliveryDate;
	/** 税金*/
	private BigDecimal taxAmount;
	/** 收入门店*/
	private String incomeStoreNo;
	/** 操作人*/
	private String operatorName;
	//添加字段2017-07-04	AverageJoe	start
	/**纳税人标识号*/
	private String taxId;
	/**注册电话*/
	private String registPhoneNo;
	/**注册地址*/
	private String registAddr;
	/**开户银行*/
	private String registBank;
	/**开户账号*/
	private String registAcct;
	/** 电子钱包调用接口查询是否成功 */
	private Boolean isGetWalletSuccess;

	public Boolean getGetWalletSuccess() {
		return isGetWalletSuccess;
	}

	public void setGetWalletSuccess(Boolean getWalletSuccess) {
		isGetWalletSuccess = getWalletSuccess;
	}
	/**销售员编号*/
	private String sellerCode;
	/**销售员姓名*/
	private String sellerName;

	public String getTaxId() {
		return taxId;
	}

	public void setTaxId(String taxId) {
		this.taxId = taxId;
	}

	public String getRegistPhoneNo() {
		return registPhoneNo;
	}

	public void setRegistPhoneNo(String registPhoneNo) {
		this.registPhoneNo = registPhoneNo;
	}

	public String getRegistAddr() {
		return registAddr;
	}

	public void setRegistAddr(String registAddr) {
		this.registAddr = registAddr;
	}

	public String getRegistBank() {
		return registBank;
	}

	public void setRegistBank(String registBank) {
		this.registBank = registBank;
	}

	public String getRegistAcct() {
		return registAcct;
	}

	public void setRegistAcct(String registAcct) {
		this.registAcct = registAcct;
	}
	//添加字段2017-07-04	AverageJoe	end


	/**
	 * @return the id
	 */
	public Integer getId() {
		return id;
	}
	/**
	 * @param id the id to set
	 */
	public void setId(Integer id) {
		this.id = id;
	}
	/**
	 * @return the storeName
	 */
	public String getStoreName() {
		return storeName;
	}
	/**
	 * @param storeName the storeName to set
	 */
	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}
	/**
	 * @return the members_name
	 */
	public String getMembers_name() {
		return members_name;
	}
	/**
	 * @param members_name the members_name to set
	 */
	public void setMembers_name(String members_name) {
		this.members_name = members_name;
	}
	/**
	 * @return the work_routine
	 */
	public String getWork_routine() {
		return work_routine;
	}
	/**
	 * @param work_routine the work_routine to set
	 */
	public void setWork_routine(String work_routine) {
		this.work_routine = work_routine;
	}
	/**
	 * @return the members_phone
	 */
	public String getMembers_phone() {
		return members_phone;
	}
	/**
	 * @param members_phone the members_phone to set
	 */
	public void setMembers_phone(String members_phone) {
		this.members_phone = members_phone;
	}
	/**
	 * @return the channelsOrder
	 */
	public String getChannelsOrder() {
		return channelsOrder;
	}
	/**
	 * @param channelsOrder the channelsOrder to set
	 */
	public void setChannelsOrder(String channelsOrder) {
		this.channelsOrder = channelsOrder;
	}
	/**
	 * @return the order_bn
	 */
	public String getOrder_bn() {
		return order_bn;
	}
	/**
	 * @param order_bn the order_bn to set
	 */
	public void setOrder_bn(String order_bn) {
		this.order_bn = order_bn;
	}
	/**
	 * @return the cost_item
	 */
	public BigDecimal getCost_item() {
		return cost_item;
	}
	/**
	 * @param cost_item the cost_item to set
	 */
	public void setCost_item(BigDecimal cost_item) {
		this.cost_item = cost_item;
	}
	/**
	 * @return the cost_tax
	 */
	public BigDecimal getCost_tax() {
		return cost_tax;
	}
	/**
	 * @param cost_tax the cost_tax to set
	 */
	public void setCost_tax(BigDecimal cost_tax) {
		this.cost_tax = cost_tax;
	}
	/**
	 * @return the createtime
	 */
	public Date getCreatetime() {
		return createtime;
	}
	/**
	 * @param createtime the createtime to set
	 */
	public void setCreatetime(Date createtime) {
		this.createtime = createtime;
	}
	/**
	 * @return the cur_amount
	 */
	public BigDecimal getCur_amount() {
		return cur_amount;
	}
	/**
	 * @param cur_amount the cur_amount to set
	 */
	public void setCur_amount(BigDecimal cur_amount) {
		this.cur_amount = cur_amount;
	}
	/**
	 * @return the currency
	 */
	public String getCurrency() {
		return currency;
	}
	/**
	 * @param currency the currency to set
	 */
	public void setCurrency(String currency) {
		this.currency = currency;
	}
	/**
	 * @return the custom_mark
	 */
	public String getCustom_mark() {
		return custom_mark;
	}
	/**
	 * @param custom_mark the custom_mark to set
	 */
	public void setCustom_mark(String custom_mark) {
		this.custom_mark = custom_mark;
	}
	/**
	 * @return the discount
	 */
	public Integer getDiscount() {
		return discount;
	}
	/**
	 * @param discount the discount to set
	 */
	public void setDiscount(Integer discount) {
		this.discount = discount;
	}
	/**
	 * @return the is_tax
	 */
	public Boolean getIs_tax() {
		return is_tax;
	}
	/**
	 * @param is_tax the is_tax to set
	 */
	public void setIs_tax(Boolean is_tax) {
		this.is_tax = is_tax;
	}
	/**
	 * @return the lastmodify
	 */
	public Date getLastmodify() {
		return lastmodify;
	}
	/**
	 * @param lastmodify the lastmodify to set
	 */
	public void setLastmodify(Date lastmodify) {
		this.lastmodify = lastmodify;
	}
	/**
	 * @return the modified
	 */
	public Date getModified() {
		return modified;
	}
	/**
	 * @param modified the modified to set
	 */
	public void setModified(Date modified) {
		this.modified = modified;
	}
	/**
	 * @return the order_items
	 */
	public List<OrderItemVo> getOrder_items() {
		return order_items;
	}
	/**
	 * @param order_items the order_items to set
	 */
	public void setOrder_items(List<OrderItemVo> order_items) {
		this.order_items = order_items;
	}
	/**
	 * @return the pay_bn
	 */
	public String getPay_bn() {
		return pay_bn;
	}
	/**
	 * @param pay_bn the pay_bn to set
	 */
	public void setPay_bn(String pay_bn) {
		this.pay_bn = pay_bn;
	}
	/**
	 * @return the pay_status
	 */
	public Integer getPay_status() {
		return pay_status;
	}
	/**
	 * @param pay_status the pay_status to set
	 */
	public void setPay_status(Integer pay_status) {
		this.pay_status = pay_status;
	}
	/**
	 * @return the payed
	 */
	public BigDecimal getPayed() {
		return payed;
	}
	/**
	 * @param payed the payed to set
	 */
	public void setPayed(BigDecimal payed) {
		this.payed = payed;
	}
	/**
	 * @return the payinfo
	 */
	public PayInfoVo getPayinfo() {
		return payinfo;
	}
	/**
	 * @param payinfo the payinfo to set
	 */
	public void setPayinfo(PayInfoVo payinfo) {
		this.payinfo = payinfo;
	}

	/**
	 * @return the pmt_detail
	 */
	public List<PmtDetail> getPmt_detail() {
		return pmt_detail;
	}
	/**
	 * @param pmt_detail the pmt_detail to set
	 */
	public void setPmt_detail(List<PmtDetail> pmt_detail) {
		this.pmt_detail = pmt_detail;
	}
	/**
	 * @return the pmt_order
	 */
	public BigDecimal getPmt_order() {
		return pmt_order;
	}
	/**
	 * @param pmt_order the pmt_order to set
	 */
	public void setPmt_order(BigDecimal pmt_order) {
		this.pmt_order = pmt_order;
	}
	/**
	 * @return the pmt_goods
	 */
	public BigDecimal getPmt_goods() {
		return pmt_goods;
	}
	/**
	 * @param pmt_goods the pmt_goods to set
	 */
	public void setPmt_goods(BigDecimal pmt_goods) {
		this.pmt_goods = pmt_goods;
	}
	/**
	 * @return the ship_status
	 */
	public Integer getShip_status() {
		return ship_status;
	}
	/**
	 * @param ship_status the ship_status to set
	 */
	public void setShip_status(Integer ship_status) {
		this.ship_status = ship_status;
	}
	/**
	 * @return the shipping
	 */
	public ShippingVo getShipping() {
		return shipping;
	}
	/**
	 * @param shipping the shipping to set
	 */
	public void setShipping(ShippingVo shipping) {
		this.shipping = shipping;
	}
	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}
	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}
	/**
	 * @return the total_amount
	 */
	public BigDecimal getTotal_amount() {
		return total_amount;
	}
	/**
	 * @param total_amount the total_amount to set
	 */
	public void setTotal_amount(BigDecimal total_amount) {
		this.total_amount = total_amount;
	}
	/**
	 * @return the consignee
	 */
	public ConsigneeVo getConsignee() {
		return consignee;
	}
	/**
	 * @param consignee the consignee to set
	 */
	public void setConsignee(ConsigneeVo consignee) {
		this.consignee = consignee;
	}
	/**
	 * @return the ordersource
	 */
	public String getOrdersource() {
		return ordersource;
	}
	/**
	 * @param ordersource the ordersource to set
	 */
	public void setOrdersource(String ordersource) {
		this.ordersource = ordersource;
	}
	/**
	 * @return the to_node_id
	 */
	public String getTo_node_id() {
		return to_node_id;
	}
	/**
	 * @param to_node_id the to_node_id to set
	 */
	public void setTo_node_id(String to_node_id) {
		this.to_node_id = to_node_id;
	}
	/**
	 * @return the invoiceTitle
	 */
	public String getInvoiceTitle() {
		return invoiceTitle;
	}
	/**
	 * @param invoiceTitle the invoiceTitle to set
	 */
	public void setInvoiceTitle(String invoiceTitle) {
		this.invoiceTitle = invoiceTitle;
	}
	/**
	 * @return the invoiceDetails
	 */
	public String getInvoiceDetails() {
		return invoiceDetails;
	}
	/**
	 * @param invoiceDetails the invoiceDetails to set
	 */
	public void setInvoiceDetails(String invoiceDetails) {
		this.invoiceDetails = invoiceDetails;
	}
	/**
	 * @return the isPaperInvoice
	 */
	public Boolean getIsPaperInvoice() {
		return isPaperInvoice;
	}
	/**
	 * @param isPaperInvoice the isPaperInvoice to set
	 */
	public void setIsPaperInvoice(Boolean isPaperInvoice) {
		this.isPaperInvoice = isPaperInvoice;
	}
	/**
	 * @return the storeNo
	 */
	public String getStoreNo() {
		return storeNo;
	}
	/**
	 * @param storeNo the storeNo to set
	 */
	public void setStoreNo(String storeNo) {
		this.storeNo = storeNo;
	}
	/**
	 * @return the shopBn
	 */
	public String getShopBn() {
		return shopBn;
	}
	/**
	 * @param shopBn the shopBn to set
	 */
	public void setShopBn(String shopBn) {
		this.shopBn = shopBn;
	}
	/**
	 * @return the invoiceType
	 */
	public String getInvoiceType() {
		return invoiceType;
	}
	/**
	 * @param invoiceType the invoiceType to set
	 */
	public void setInvoiceType(String invoiceType) {
		this.invoiceType = invoiceType;
	}
	/**
	 * @return the orderType
	 */
	public String getOrderType() {
		return orderType;
	}
	/**
	 * @param orderType the orderType to set
	 */
	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	/**
	 * @return the isPumpSplit
	 */
	public Boolean getIsPumpSplit() {
		return isPumpSplit;
	}
	/**
	 * @param isPumpSplit the isPumpSplit to set
	 */
	public void setIsPumpSplit(Boolean isPumpSplit) {
		this.isPumpSplit = isPumpSplit;
	}
	/**
	 * @return the shippingOrder
	 */
	public Integer getShippingOrder() {
		return shippingOrder;
	}
	/**
	 * @param shippingOrder the shippingOrder to set
	 */
	public void setShippingOrder(Integer shippingOrder) {
		this.shippingOrder = shippingOrder;
	}
	/**
	 * @return the isHasDelivery
	 */
	public Boolean getIsHasDelivery() {
		return isHasDelivery;
	}
	/**
	 * @param isHasDelivery the isHasDelivery to set
	 */
	public void setIsHasDelivery(Boolean isHasDelivery) {
		this.isHasDelivery = isHasDelivery;
	}

	/**
	 * @return the memberAccount
	 */
	public String getMemberAccount() {
		return memberAccount;
	}
	/**
	 * @param memberAccount the memberAccount to set
	 */
	public void setMemberAccount(String memberAccount) {
		this.memberAccount = memberAccount;
	}
	/**
	 * @return the memberLevel
	 */
	public Integer getMemberLevel() {
		return memberLevel;
	}
	/**
	 * @param memberLevel the memberLevel to set
	 */
	public void setMemberLevel(Integer memberLevel) {
		this.memberLevel = memberLevel;
	}
	/**
	 * @return the sellerMark
	 */
	public String getSellerMark() {
		return sellerMark;
	}
	/**
	 * @param sellerMark the sellerMark to set
	 */
	public void setSellerMark(String sellerMark) {
		this.sellerMark = sellerMark;
	}
	/**
	 * @return the sendingTime
	 */
	public Date getSendingTime() {
		return sendingTime;
	}
	/**
	 * @param sendingTime the sendingTime to set
	 */
	public void setSendingTime(Date sendingTime) {
		this.sendingTime = sendingTime;
	}
	/**
	 * @return the lastModifyDeliveryDate
	 */
	public Date getLastModifyDeliveryDate() {
		return lastModifyDeliveryDate;
	}
	/**
	 * @param lastModifyDeliveryDate the lastModifyDeliveryDate to set
	 */
	public void setLastModifyDeliveryDate(Date lastModifyDeliveryDate) {
		this.lastModifyDeliveryDate = lastModifyDeliveryDate;
	}
	/**
	 * @return the taxAmount
	 */
	public BigDecimal getTaxAmount() {
		return taxAmount;
	}
	/**
	 * @param taxAmount the taxAmount to set
	 */
	public void setTaxAmount(BigDecimal taxAmount) {
		this.taxAmount = taxAmount;
	}
	/**
	 * @return the incomeStoreNo
	 */
	public String getIncomeStoreNo() {
		return incomeStoreNo;
	}
	/**
	 * @param incomeStoreNo the incomeStoreNo to set
	 */
	public void setIncomeStoreNo(String incomeStoreNo) {
		this.incomeStoreNo = incomeStoreNo;
	}
	/**
	 * @return the deliveryVersion
	 */
	public Integer getDeliveryVersion() {
		return deliveryVersion;
	}
	/**
	 * @param deliveryVersion the deliveryVersion to set
	 */
	public void setDeliveryVersion(Integer deliveryVersion) {
		this.deliveryVersion = deliveryVersion;
	}
	/**
	 * 当前配送版本
	 * @Title: getCurrentVersion
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年5月24日 下午3:56:01
	 */
	public String getCurrentVersion() {
		return "currentversion_"+getDeliveryVersion();
	}

	/**
	 * @return the pmt_plateform
	 */
	public BigDecimal getPmt_plateform() {
		return pmt_plateform;
	}
	/**
	 * @param pmt_plateform the pmt_plateform to set
	 */
	public void setPmt_plateform(BigDecimal pmt_plateform) {
		this.pmt_plateform = pmt_plateform;
	}
	/**
	 * @return the operatorName
	 */
	public String getOperatorName() {
		return operatorName;
	}
	/**
	 * @param operatorName the operatorName to set
	 */
	public void setOperatorName(String operatorName) {
		this.operatorName = operatorName;
	}

	public String getSellerCode() {
		return sellerCode;
	}

	public void setSellerCode(String sellerCode) {
		this.sellerCode = sellerCode;
	}

	public String getSellerName() {
		return sellerName;
	}

	public void setSellerName(String sellerName) {
		this.sellerName = sellerName;
	}

	@Override
	public String toString() {
		return "OrderBaseVo{" +
				"id=" + id +
				", ordersource='" + ordersource + '\'' +
				", to_node_id='" + to_node_id + '\'' +
				", shopBn='" + shopBn + '\'' +
				", orderType='" + orderType + '\'' +
				", order_bn='" + order_bn + '\'' +
				", cost_item=" + cost_item +
				", cost_tax=" + cost_tax +
				", createtime=" + createtime +
				", cur_amount=" + cur_amount +
				", currency='" + currency + '\'' +
				", custom_mark='" + custom_mark + '\'' +
				", discount=" + discount +
				", is_tax=" + is_tax +
				", invoiceType='" + invoiceType + '\'' +
				", invoiceTitle='" + invoiceTitle + '\'' +
				", invoiceDetails='" + invoiceDetails + '\'' +
				", isPaperInvoice=" + isPaperInvoice +
				", lastmodify=" + lastmodify +
				", modified=" + modified +
				", order_items=" + order_items +
				", pay_bn='" + pay_bn + '\'' +
				", pay_status=" + pay_status +
				", payed=" + payed +
				", payinfo=" + payinfo +
				", pmt_detail=" + pmt_detail +
				", pmt_order=" + pmt_order +
				", pmt_goods=" + pmt_goods +
				", pmt_plateform=" + pmt_plateform +
				", ship_status=" + ship_status +
				", shipping=" + shipping +
				", status='" + status + '\'' +
				", total_amount=" + total_amount +
				", consignee=" + consignee +
				", storeNo='" + storeNo + '\'' +
				", isPumpSplit=" + isPumpSplit +
				", shippingOrder=" + shippingOrder +
				", isHasDelivery=" + isHasDelivery +
				", deliveryVersion=" + deliveryVersion +
				", channelsOrder='" + channelsOrder + '\'' +
				", members_name='" + members_name + '\'' +
				", work_routine='" + work_routine + '\'' +
				", members_phone='" + members_phone + '\'' +
				", storeName='" + storeName + '\'' +
				", memberAccount='" + memberAccount + '\'' +
				", memberLevel=" + memberLevel +
				", sellerMark='" + sellerMark + '\'' +
				", sendingTime=" + sendingTime +
				", lastModifyDeliveryDate=" + lastModifyDeliveryDate +
				", taxAmount=" + taxAmount +
				", incomeStoreNo='" + incomeStoreNo + '\'' +
				", operatorName='" + operatorName + '\'' +
				", taxId='" + taxId + '\'' +
				", registPhoneNo='" + registPhoneNo + '\'' +
				", registAddr='" + registAddr + '\'' +
				", registBank='" + registBank + '\'' +
				", registAcct='" + registAcct + '\'' +
				", sellerCode='" + sellerCode + '\'' +
				", sellerName='" + sellerName + '\'' +
				'}';
	}
}
