/**
 * @Description: 
 * @ClassName: com.biz.oms.service.OmsOrderDeliveryApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年5月22日 下午6:41:12 
 */
package com.biz.oms.service;

import java.util.Map;

import com.biz.oms.parseVo.ConsigneeVo;
import com.biz.oms.parseVo.OrderBaseVo;


/**
 * 配送单 接口服务
 * @Description: 
 * @ClassName: com.biz.oms.service.OmsOrderDeliveryApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年5月22日 下午6:41:12 
 *
 */
public interface OmsOrderDeliveryApiService {
	
	/**
	 * 获取配送单快照JSON字符串 通过ES
	 * @Title: findDeliveryJsonByES 
	 * @param orderBn 订单编号
	 * @param version 版本编号
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月29日 上午11:38:22
	 */
	public String getDeliverySnapshotsJsonByES(String orderBn,String version);
	
	/**
	 * 获取订单快照JSON字符串 通过ES
	 * @Title: getOrderSnapshotsJsonByES 
	 * @param orderBn 订单编号
	 * @param version 版本编号
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月29日 上午11:39:44
	 */
	public String getOrderSnapshotsJsonByES(String orderBn,String version);
	
	/**
	 * 订单改派
	 * @Title: insertOrderDeliveryInfo 
	 * @param orderBn 订单编号
	 * @param storeNo 门店编号
	 * @param storeName 门店名称
	 * @param sellerMark 卖家备注
	 * @param consignee 收货人信息
	 * @param operatorName 操作人
	 * @return 改派是否成功
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月20日 下午11:56:10
	 */
	public Map<String,Object> saveOrderChangeForDelivery(String orderBn, String storeNo, String storeName, String sellerMark, ConsigneeVo consignee,String operatorName);
	
	/**
	 * 订单分单
	 * @Title: updatePumpTime 
	 * @param orderBn 订单编号
	 * @param storeNo 门店编号
	 * @param storeName 门店名称
	 * @param sellerMark 卖家备注
	 * @param consignee 收货人信息
	 * @param operatorName 操作人
	 * @return 改派是否成功
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月20日 下午11:56:10
	 */
	public Map<String,Object> updatePumpTime(String orderBn, String storeNo, String storeName, String sellerMark, ConsigneeVo consignee,String operatorName);

	/**
	 * 订单改派
	 * @Title: insertOrderDeliveryInfo 
	 * @param orderBaseVo 订单信息
	 * @param operatorName 操作人
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年6月20日 下午11:56:10
	 */
	public Map<String,Object> splitOrderReassion(OrderBaseVo orderBaseVo, String operatorName);
	
}
