/**
 * @Description: 
 * @ClassName: com.biz.oms.service.OmsOrderLogicHanderApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年5月4日 上午10:12:25 
 */
package com.biz.oms.service;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.biz.oms.parseVo.ConsigneeVo;
import com.biz.oms.parseVo.OrderBaseVo;
import com.biz.oms.parseVo.ProductInfoVo;

/**
 * OMS 订单逻辑处理
 * @Description: 
 * @ClassName: com.biz.oms.service.OmsOrderLogicHanderApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年5月4日 上午10:12:25 
 *
 */
public interface OmsOrderLogicHanderApiService {
	
	/**
	 * 是否有订单记录 通过ES
	 * @Title: hasOrderRecord 
	 * @param orderSn 订单编号
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年4月22日 下午5:29:31
	 */
	public Boolean hasOrderRecordByES(String orderSn);
	
	/**
	 * 根据订单编号从ES中查找
	 * 返回订单JSON数据
	 * @Title: findOrderJsonByOrderSn 
	 * @param orderSn 订单编号
	 * @return 订单JSON数据
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月5日 下午3:37:30
	 */
	public String findOrderJsonByES(String orderSn);

	/**
	 *  根据订单编号 判断订单记录是否存在
	 * @Title: isExists 
	 * @param orderSn 订单编号
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年4月27日 上午12:45:38
	 */
	public Boolean isExists(String orderSn);

	/**
	 * 自动判断 并实现保存
	 * @Title: autoJudgeToSave 
	 * @param isRightNowOrder 是否立即送订单
	 * @param decodeStr 订单JSON
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月4日 上午9:42:38
	 */
	public void autoJudgeToSave(Boolean isRightNowOrder, String decodeStr);

	/**
	 * 将订单push 到JDE中
	 * 注: 该订单已存储在本地数据库.
	 * 需要对数据进行同步到 JDE 中
	 * 主要用于OMS
	 * @Title: pushOrderToJDE 
	 * @param orderBaseVo
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月13日 下午3:37:57
	 */
	public void pushOrderToJDE(OrderBaseVo orderBaseVo);
	
	/**
	 * 针对从平台拉单时,进行去重保存
	 * @Title: orderLogicHandler 
	 * @param jsonOrderValus
	 * @param isRightNowOrder
	 * @throws UnsupportedEncodingException
	 * @author: dick.dai(Administrator)
	 * @date: 2016年5月21日 下午1:41:25
	 */
	public void orderLogicHandler(String jsonOrderValus,Boolean isRightNowOrder) throws UnsupportedEncodingException;
	
	/**
	 * 递归获取商品信息
	 * 组合商品
	 * 商品A购买了10件 所花费 100元,但是由不同的商品 b1,b2 组合而成,
	 * 通过获取,b1 占比例 70%,b2 占比例 30% 并且b1数量为5件,b2为12件
	 * 那么b1单价 = 100/10*0.7/5 
	 * @Title: getProductInfoByTree 
	 * @param orderItemBn 订单项编号(组合商品编号)
	 * @param orderBn 订单编号
	 * @param price 商品单价
	 * @param gPrice 购买价
	 * @param itemCounts 商品数量 默认为1;
	 * @param sourceScale 比例 默认为1
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年4月26日 下午10:55:16
	 */
	public List<ProductInfoVo> getProductInfoByTree(String orderItemBn, String orderBn, BigDecimal price, BigDecimal gPrice,Integer itemCounts,Double sourceScale);

	/**
	 * 更新订单中组合商品 
	 * 拆分后的组合商品是否为空
	 * @Title: updateSplitGroupProductStatus 
	 * @param orderId 订单ID
	 * @param isSplitNull 拆分后的组合商品是否为空(0位非空 , 1为空 ) 
	 * @author: Omar(OmarZhang)
	 * @date: 2016年7月2日 下午6:52:44
	 */
	public void updateSplitGroupProductStatus(Integer orderId,Boolean isSplitNull);
	

	/**
	 * 根据收货人信息查询地址经纬度
	 * @Title: getLatLngByConsignee 
	 * @param orderBn 订单编号
	 * @param consigneeDto 收货人信息
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年7月14日 上午12:12:30
	 */
	public Map<String,BigDecimal> getLatLngByConsignee(String orderBn,ConsigneeVo consigneeVo);
	/**
	 * 根据时间从日志中批量查询订单信息,并进行补单
	 * @Title: findOrdersByEs 
	 * @param times
	 * @return
	 * @author: dick.dai(Administrator)
	 * @date: 2016年8月4日 下午10:28:10
	 */
	public Boolean findOrdersByEs(List<String> times);
	/**
	 * 根据时间从日志中批量查询订单信息,并进行补单
	 * @Title: findOrdersByEs 
	 * @param times
	 * @param name 操作人
	 * @return
	 * @author: dick.dai(Administrator)
	 * @date: 2016年8月4日 下午10:28:10
	 */
	public Boolean newFindOrdersByEs(List<String> times,String name);

	/**
	 * 库存搜索 加入同步锁
	 * 返回true/false 库存是否满足
	 * @Title: searchHasInventoryByItems 
	 * @param orderBaseInfo
	 * @param storeNo 门店编号
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年10月13日 下午3:11:34
	 */
	public Boolean searchHasInventoryByItems(OrderBaseVo orderBaseVo, String storeNo);
	
	/**
	 * 库存搜索 加入同步锁
	 * 返回true/false 库存是否满足
	 * @Title: searchHasInventoryByItems 
	 * @param productItems 商品项 key:商品编号 value: 数量
	 * @param storeNo 门店编号
	 * @param orderBn 订单编号
	 * @param orderSource 订单来源
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年10月13日 下午3:11:34
	 */
	public Boolean searchHasInventoryByItems(Map<String,Integer> productItems,String orderBn,String orderSource, String storeNo);
	
	/**
	 * 订单商品拆分
	 * 转换为商品编号 -- > 数量
	 * @Title: parseOrderToProducts 
	 * @param orderBaseVo
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年10月17日 下午8:07:16
	 */
	public Map<String,Integer> parseOrderToProducts(OrderBaseVo orderBaseVo);
	
	/**
	 * 释放某个门店下的订单的商品库存
	 * @Title: isHasStoreRelease 
	 * @param orderBaseVo
	 * @param storeNo
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年11月24日 下午2:47:04
	 */
	public Boolean isHasStoreRelease(OrderBaseVo orderBaseVo, String storeNo);

	/**
	 * 更改订单金额
	 * @Title: updatePmtInfoByOrderBn 
	 * @param orderBn
	 * @param costItem 商品总金额(不更改传null)
	 * @param totalAmount 订单总金额(不更改传null)
	 * @param payed 订单已支付金额(不更改传null)
	 * @param pmtOrder 订单优惠金额(不更改传null)
	 * @param pmtGoods 订单商品优惠金额(不更改传null)
	 * @param pmtPlateform 订单平台优惠金额(不更改传null)
	 * @param costShipping 订单运费(不更改传null)
	 * @param payStatus 订单支付状态(不更改传null)
	 * @author: TRivers.chen(Administrator)
	 * @date: 2017年3月12日 下午5:03:50
	 */
	public void updatePmtInfoByOrderBn(String orderBn, BigDecimal costItem, BigDecimal totalAmount, BigDecimal payed, 
			BigDecimal pmtOrder, BigDecimal pmtGoods, BigDecimal pmtPlateform,BigDecimal costShipping,Integer payStatus);

	/**
	 * 更改订单项商品编号
	 * @Title: updateOrderItemBnByOrderBn 
	 * @param orderItemJson
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年11月30日 下午6:16:00
	 */
	public void updateOrderItemBnByOrderBn(String orderItemJson);
	
}
