/*
 * Decompiled with CFR 0.152.
 */
package com.biz.oms.utils;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.data.Stat;

public abstract class ZookeeperClientUtils {
    private static String ZKURL = "127.0.0.1";
    private static final String TEMPDEFATULNODEPARENTPATH = "/cpmachine";
    private static final String TEMPDEFATULNODEPATH = "/cpmachine/limitmq";
    private String DEFATULNODEPARENTPATH = "/cpmachine";
    private String DEFATULNODEPATH = "/cpmachine/limitmq";
    private CuratorFramework curatorFramework = null;

    private CuratorFramework getClient() {
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(ZKURL).sessionTimeoutMs(5000).connectionTimeoutMs(3000).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).build();
        return curatorFramework;
    }

    public void init(String url, String nodePath, String nodeParentPath) {
        ZKURL = url;
        this.DEFATULNODEPARENTPATH = nodeParentPath;
        this.DEFATULNODEPATH = nodePath;
        this.watchChangeData();
    }

    public void init(String url) {
        ZKURL = url;
        this.DEFATULNODEPARENTPATH = TEMPDEFATULNODEPARENTPATH;
        this.DEFATULNODEPATH = TEMPDEFATULNODEPATH;
        this.watchChangeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInit(String url) {
        try {
            ZKURL = url;
            this.DEFATULNODEPARENTPATH = TEMPDEFATULNODEPARENTPATH;
            this.DEFATULNODEPATH = TEMPDEFATULNODEPATH;
            this.curatorFramework = this.getClient();
            this.curatorFramework.start();
            Stat stat = (Stat)this.curatorFramework.checkExists().forPath(this.DEFATULNODEPATH);
            if (stat == null) {
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(this.DEFATULNODEPATH, new byte[0]);
            }
            byte[] bytes = (byte[])this.curatorFramework.getData().forPath(this.DEFATULNODEPATH);
            this.readData(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.curatorFramework.close();
        }
    }

    private void watchChangeData() {
        try {
            this.curatorFramework = this.getClient();
            this.curatorFramework.start();
            Stat stat = (Stat)this.curatorFramework.checkExists().forPath(this.DEFATULNODEPATH);
            if (stat == null) {
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(this.DEFATULNODEPATH, new byte[0]);
            }
            PathChildrenCache pathChildrenCache = new PathChildrenCache(this.curatorFramework, this.DEFATULNODEPARENTPATH, true);
            pathChildrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
            PathChildrenCacheListener childrenCacheListener = new PathChildrenCacheListener(){

                public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                    ChildData data = event.getData();
                    byte[] bytes = new byte[]{};
                    if (data != null) {
                        bytes = data.getData();
                    }
                    switch (event.getType()) {
                        case CHILD_ADDED: {
                            ZookeeperClientUtils.this.readData(bytes);
                            break;
                        }
                        case CHILD_REMOVED: {
                            ZookeeperClientUtils.this.readData(bytes);
                            break;
                        }
                        case CHILD_UPDATED: {
                            ZookeeperClientUtils.this.readData(bytes);
                            break;
                        }
                    }
                }
            };
            pathChildrenCache.getListenable().addListener((Object)childrenCacheListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void readData(byte[] var1);
}

