/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class PrimusLocalTimeDeserializer
extends JsonDeserializer<LocalTime> {
    private static final DateTimeFormatter PRIMUS_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public LocalTime deserialize(JsonParser p, DeserializationContext dctx) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)p.getText())) {
            String text = p.getText().trim();
            return LocalTime.from(PRIMUS_TIME_FORMATTER.parse(text));
        }
        return null;
    }
}

