/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import com.google.common.collect.Table;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CopyUtils {
    private static WeakHashMap<Method, Method> bridgeMethodCache = new WeakHashMap();

    private CopyUtils() {
    }

    public static <T> T copyProperties(Object source, T target) {
        return CopyUtils.copyProperties(source, target, false, new String[0]);
    }

    public static <T> T copyProperties(Object source, T target, String ... ignoreProperties) {
        return CopyUtils.copyProperties(source, target, false, ignoreProperties);
    }

    public static <T> T copyNotNullProperies(Object source, T target) {
        return CopyUtils.copyProperties(source, target, true, new String[0]);
    }

    public static <T> T copyNotNullProperties(Object source, T target, String ... ignoreProperties) {
        return CopyUtils.copyProperties(source, target, true, ignoreProperties);
    }

    private static <T> T copyProperties(Object source, T target, boolean ignoreNullValue, String ... ignoreProperties) {
        return CopyUtils.copyProperties(source, target, ignoreNullValue, null, ignoreProperties);
    }

    static <T> T copyProperties(Object source, T target, boolean ignoreNullValue, Table<Class, Class, Converter> converterTable, String ... ignoreProperties) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull(target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<Object> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : Collections.emptyList();
        for (PropertyDescriptor targetPd : targetPds) {
            Object value;
            boolean useTable;
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod;
            if (ignoreList.contains(targetPd.getName()) || (writeMethod = CopyUtils.resolveBridgeMethod(targetPd.getWriteMethod())) == null || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = CopyUtils.resolveBridgeMethod(sourcePd.getReadMethod())) == null) continue;
            Class<?> sourcePropertyType = readMethod.getReturnType();
            Class<?> targetPropertyType = writeMethod.getParameterTypes()[0];
            boolean bl = useTable = converterTable != null && !converterTable.isEmpty();
            if (ClassUtils.isAssignable(targetPropertyType, sourcePropertyType)) {
                try {
                    value = readMethod.invoke(source, new Object[0]);
                    if (value == null && ignoreNullValue) continue;
                    writeMethod.invoke(target, value);
                    continue;
                }
                catch (Throwable ex) {
                    throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
                }
            }
            if (!useTable || !converterTable.contains(sourcePropertyType, targetPropertyType)) continue;
            try {
                value = readMethod.invoke(source, new Object[0]);
                if (value == null && ignoreNullValue) continue;
                Converter converter = (Converter)converterTable.get(sourcePropertyType, targetPropertyType);
                Object destValue = converter.convert(value);
                writeMethod.invoke(target, destValue);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
        return target;
    }

    private static Method resolveBridgeMethod(Method sourceMethod) {
        if (sourceMethod == null) {
            return null;
        }
        if (sourceMethod.isBridge()) {
            return bridgeMethodCache.computeIfAbsent(sourceMethod, k -> BridgeMethodResolver.findBridgedMethod((Method)sourceMethod));
        }
        return sourceMethod;
    }
}

