/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import java.util.List;

public class MathUtil {
    public static Double getMax(Double[] inputData) {
        if (inputData == null || inputData.length == 0) {
            return -1.0;
        }
        Double max = inputData[0];
        for (Double anInputData : inputData) {
            if (!(max < anInputData)) continue;
            max = anInputData;
        }
        return max;
    }

    public static Double getMin(Double[] inputData) {
        if (inputData == null || inputData.length == 0) {
            return -1.0;
        }
        Double min = inputData[0];
        for (Double anInputData : inputData) {
            if (!(min > anInputData)) continue;
            min = anInputData;
        }
        return min;
    }

    public static Double getSum(Double[] inputData) {
        if (inputData == null || inputData.length == 0) {
            return -1.0;
        }
        Double sum = 0.0;
        for (Double anInputData : inputData) {
            sum = sum + anInputData;
        }
        return sum;
    }

    public static int getCount(Double[] inputData) {
        return inputData == null ? -1 : inputData.length;
    }

    public static Double getAverage(Double[] inputData) {
        return inputData == null || inputData.length == 0 ? -1.0 : MathUtil.getSum(inputData) / (double)inputData.length;
    }

    public static Double getSquareSum(Double[] inputData) {
        if (inputData == null || inputData.length == 0) {
            return -1.0;
        }
        Double sqrNum = 0.0;
        for (Double anInputData : inputData) {
            sqrNum = sqrNum + anInputData * anInputData;
        }
        return sqrNum;
    }

    public static Double getVariance(Double[] inputData) {
        return (MathUtil.getSquareSum(inputData) - (double)MathUtil.getCount(inputData) * MathUtil.getAverage(inputData) * MathUtil.getAverage(inputData)) / (double)MathUtil.getCount(inputData);
    }

    public static Double getStandardDiviation(List<Double> inputList) {
        Double[] inputData = new Double[inputList.size()];
        for (int i = 0; i < inputList.size(); ++i) {
            inputData[i] = inputList.get(i);
        }
        return Math.sqrt(Math.abs(MathUtil.getVariance(inputData)));
    }

    public static int randomInt(int min, int max) {
        return (int)Math.round(Math.random() * (double)(max - min) + (double)min);
    }
}

