/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.springframework.core.NamedThreadLocal;

public class MoneyConverter {
    public static final MoneyConverter instance = new MoneyConverter();
    private static final ThreadLocal<DecimalFormat> tl = new NamedThreadLocal("money format thread local");

    private MoneyConverter() {
    }

    public String fen2yuan(Integer fen) {
        BigDecimal _100 = BigDecimal.valueOf(100L);
        return MoneyConverter.getFormat().format(BigDecimal.valueOf(fen.intValue()).divide(_100));
    }

    private static DecimalFormat getFormat() {
        DecimalFormat df = tl.get();
        if (df == null) {
            df = new DecimalFormat("0.00");
            tl.set(df);
        }
        return df;
    }
}

