/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssUtil {
    private static Logger logger = LoggerFactory.getLogger(OssUtil.class);

    private static void OSSExceptionLoggerPrint(OSSException oe) throws Exception {
        logger.error("oss\u670d\u52a1\u7aef\u5f02\u5e38...\n");
        logger.error("errorCode:\n", (Object)oe.getErrorCode());
        logger.error("errorMsg:\n", (Object)oe.getErrorMessage());
        logger.error("requestId:\n", (Object)oe.getRequestId());
        logger.error("hostId:\n", (Object)oe.getHostId());
        throw new Exception(oe.getErrorMessage(), oe);
    }

    private static void clientExceptionLoggerPrint(ClientException ce) throws Exception {
        logger.error("oss\u5ba2\u6237\u7aef\u5f02\u5e38...\n");
        logger.error("errorCode:\n", (Object)ce.getErrorCode());
        logger.error("errorMsg:\n", (Object)ce.getErrorMessage());
        throw new Exception(ce.getErrorMessage(), ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObject(OSSClient client, PutObjectRequest putObjectRequest) throws Exception, IOException {
        try {
            logger.debug("\u4e0a\u4f20object\u5230\u540d\u4e3a\uff1a" + putObjectRequest.getBucketName() + "\u7684bucket");
            PutObjectResult putObjectResult = client.putObject(putObjectRequest);
            if (putObjectRequest.getCallback() != null) {
                byte[] buffer = new byte[1024];
                putObjectResult.getCallbackResponseBody().read(buffer);
                putObjectResult.getCallbackResponseBody().close();
            }
        }
        catch (OSSException oe) {
            OssUtil.OSSExceptionLoggerPrint(oe);
        }
        catch (ClientException ce) {
            OssUtil.clientExceptionLoggerPrint(ce);
        }
    }

    public static String getOssResourceUri(String bucketName, String endPoint, String key) {
        return String.format("https://%s.%s/%s", bucketName, endPoint, key);
    }

    public static String getOssImgUrl(String bucketName, String endPoint, String key) {
        if (!StringUtils.isEmpty((CharSequence)key)) {
            return String.format("http://%s.%s/%s", bucketName, endPoint, key);
        }
        return null;
    }

    public static String getPrefixOssResourceUri(String bucketName, String endPoint) {
        return String.format("https://%s.%s/", bucketName, endPoint);
    }
}

