/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;

public class PingYinUtil {
    public static String getPingYin(String inputString) {
        if (StringUtils.isEmpty((CharSequence)inputString)) {
            return "";
        }
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
        char[] input = inputString.trim().toCharArray();
        StringBuffer pybf = new StringBuffer();
        try {
            for (int i = 0; i < input.length; ++i) {
                if (Character.toString(input[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)input[i], (HanyuPinyinOutputFormat)format);
                    pybf.append(temp[0]);
                    continue;
                }
                pybf.append(Character.toString(input[i]));
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return pybf.toString();
    }

    public static String getFirstSpell(String chinese) {
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    public static String getFullSpell(String chinese) {
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    pybf.append(PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat)[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString();
    }

    public static String getFirstLetter(String inputStr) {
        String str = PingYinUtil.getFirstSpell(inputStr);
        return StringUtils.isNotEmpty((CharSequence)str) ? String.valueOf(str.charAt(0)).toUpperCase() : "";
    }
}

