/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import com.biz.primus.common.utils.SyncExecutionUnit;

public class SyncUtil {
    private final int lockStoreSize;
    private final Object[] lockStore;

    public SyncUtil(int lockStoreSize) {
        this.lockStoreSize = lockStoreSize;
        this.lockStore = new Object[lockStoreSize];
        for (int i = 0; i < this.lockStore.length; ++i) {
            this.lockStore[i] = new Object();
        }
    }

    public SyncUtil() {
        this(64);
    }

    private Object getSyncLock(Object source) {
        if (source == null) {
            throw new RuntimeException("source \u4e0d\u80fd\u4e3anull");
        }
        return this.lockStore[Math.abs(source.hashCode() % this.lockStoreSize)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T syncExecute(SyncExecutionUnit unit) {
        Object lock = this.getSyncLock(unit.getSyncLockSource());
        if (unit.isExecutable()) {
            Object object = lock;
            synchronized (object) {
                if (unit.isExecutable()) {
                    return (T)unit.execute();
                }
            }
        }
        return null;
    }
}

