/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import com.biz.primus.common.utils.ValueUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timers {
    private static final Logger logger = LoggerFactory.getLogger(Timers.class);
    private StopWatch sw = new StopWatch();
    private Map<String, Long> map = Maps.newLinkedHashMap();
    private long preTime = 0L;
    private boolean enabled = true;
    private Logger privateLogger = null;

    private Timers() {
    }

    public static Timers createAndBegin(boolean enabled) {
        Timers timers = new Timers();
        timers.enabled = enabled;
        if (!enabled) {
            return timers;
        }
        timers.sw.start();
        return timers;
    }

    public static Timers createAndBegin(Logger logger) {
        Timers timers = new Timers();
        timers.privateLogger = logger;
        timers.enabled = logger.isDebugEnabled();
        if (!timers.enabled) {
            return timers;
        }
        timers.sw.start();
        return timers;
    }

    public void record(String tag) {
        if (!this.enabled) {
            return;
        }
        this.sw.split();
        long splitTime = this.sw.getSplitTime();
        long sub = splitTime - this.preTime;
        this.map.put(tag, sub);
        this.preTime = splitTime;
    }

    private Map<String, Long> out() {
        if (!this.enabled || this.sw.isStopped()) {
            return this.map;
        }
        this.sw.stop();
        long all = this.sw.getTime();
        this.map.put("\u603b\u8ba1\u7528\u65f6", all);
        return this.map;
    }

    public void print(String tag) {
        if (!this.enabled) {
            return;
        }
        this.getLogger().debug(tag + " {}", this.out());
    }

    private Logger getLogger() {
        return ValueUtils.getValueOrDefault(this.privateLogger, logger);
    }
}

