/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils;

import com.biz.primus.common.utils.ValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueAllocator {
    private static final Logger log = LoggerFactory.getLogger(ValueAllocator.class);
    private final double totalForAllocation;
    private int undistributedValue;
    private int allocationCounter = 0;
    private final int expectAllocationCount;
    private String mark;

    public ValueAllocator(Integer totalForAllocation, int expectAllocationCount, String mark) {
        this.totalForAllocation = ValueUtils.getValue(totalForAllocation).intValue();
        this.undistributedValue = ValueUtils.getValue(totalForAllocation);
        this.expectAllocationCount = expectAllocationCount;
        this.mark = mark;
    }

    public synchronized int allocate(double rate) {
        int expectAmount = (int)(rate * this.totalForAllocation);
        if (log.isTraceEnabled()) {
            log.trace("\u6570\u503c\u5206\u914d\u4e2d, \u9700\u6c42\u6bd4\u4f8b={}, \u603b\u8ba1\u53ef\u5206\u914d\u503c={}, \u672c\u6b21\u5e94\u5206\u914d\u503c={}, \u65e5\u5fd7\u6807\u8bb0={}", new Object[]{rate, this.totalForAllocation, expectAmount, this.mark});
        }
        ++this.allocationCounter;
        if (this.allocationCounter > this.expectAllocationCount) {
            log.error("\u6570\u503c\u5206\u914d\u9519\u8bef, \u5f53\u524d\u5206\u914d\u8ba1\u6570\u5668\u5927\u4e8e\u4e86\u603b\u5171\u671f\u671b\u5206\u914d\u7684\u6b21\u6570{},\u8bf7\u68c0\u67e5\u4ee3\u7801,mark={}", (Object)this.expectAllocationCount, (Object)this.mark);
            return 0;
        }
        if (this.allocationCounter == this.expectAllocationCount) {
            return this.undistributedValue;
        }
        if (this.undistributedValue - expectAmount < 0) {
            int temp = this.undistributedValue;
            this.undistributedValue = 0;
            log.warn("\u6570\u503c\u65e9\u4e8e\u9884\u671f\u7684\u5206\u914d\u5b8c\u6bd5,\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e,\u65e5\u5fd7\u6807\u8bb0={}", (Object)this.mark);
            return temp;
        }
        this.undistributedValue -= expectAmount;
        return expectAmount;
    }

    public double getTotalForAllocation() {
        return this.totalForAllocation;
    }

    public int getUndistributedValue() {
        return this.undistributedValue;
    }

    public int getAllocationCounter() {
        return this.allocationCounter;
    }

    public int getExpectAllocationCount() {
        return this.expectAllocationCount;
    }
}

