/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils.kmeans;

import java.util.List;

public class Cluster
implements Comparable<Cluster> {
    private int id;
    private double center;
    private List<Double> members;

    public Cluster(int id, double center, List<Double> members) {
        this.id = id;
        this.center = center;
        this.members = members;
    }

    public void addPoint(Double point) {
        this.members.add(point);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getCenter() {
        return this.center;
    }

    public void setCenter(double center) {
        this.center = center;
    }

    public List<Double> getMembers() {
        return this.members;
    }

    public void setMembers(List<Double> members) {
        this.members = members;
    }

    public void resetClusterCenter() {
        if (this.members.size() != 0) {
            Double all = 0.0;
            for (Double member : this.members) {
                all = all + member;
            }
            this.center = all / (double)this.members.size();
        }
    }

    @Override
    public int compareTo(Cluster o) {
        if (this.getCenter() > o.getCenter()) {
            return 1;
        }
        if (this.getCenter() < o.getCenter()) {
            return -1;
        }
        return 0;
    }
}

