/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.utils.kmeans;

import com.biz.primus.common.utils.MathUtil;
import com.biz.primus.common.utils.kmeans.Cluster;
import com.biz.primus.common.vo.KMeansRangeVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMeans
implements Serializable {
    private static final long serialVersionUID = 2419410936604917353L;
    private static final Integer DEFAULT_CLUSTER_NUM = 5;
    private static final Integer MAX_ITERATE_NUM = 20;
    private Logger logger = LoggerFactory.getLogger(KMeans.class);
    private List<Double> pointList;
    private List<Double> oldClusterCenter;
    private List<Double> newClusterCenter;
    private List<Cluster> clusterList;
    private int numCluster;
    private int iterateNum = 0;
    private int maxDiscrete = 3;
    private double errorRange = 1000.0;

    private void randomClusterCenter() {
        Double max = Collections.max(this.pointList);
        Double min = Collections.min(this.pointList);
        double differ = Math.abs(max - min);
        double step = differ / (double)(this.numCluster + 1);
        for (int i = 1; i <= this.numCluster; ++i) {
            this.newClusterCenter.add(min + step * (double)i);
        }
    }

    public KMeans(List<Double> pointList) {
        this(pointList, DEFAULT_CLUSTER_NUM);
    }

    public KMeans(List<Double> pointList, int numCluster) {
        if (pointList.size() - 20 > 500) {
            Collections.sort(pointList);
            this.pointList = pointList.subList(0, pointList.size() - 20);
        } else {
            this.pointList = pointList;
        }
        this.numCluster = numCluster;
        this.newClusterCenter = Lists.newArrayList();
        this.oldClusterCenter = Lists.newArrayList();
        this.randomClusterCenter();
        this.initCluster();
        this.cluster();
    }

    private void initCluster() {
        this.clusterList = Lists.newArrayList();
        int i = 0;
        for (Double center : this.newClusterCenter) {
            this.clusterList.add(new Cluster(i, center, Lists.newArrayList()));
        }
    }

    private void cluster() {
        ++this.iterateNum;
        for (Double point : this.pointList) {
            ArrayList diffList = Lists.newArrayList();
            for (Double center : this.newClusterCenter) {
                double diff = Math.abs(point - center);
                diffList.add(diff);
            }
            Double min = (Double)Collections.min(diffList);
            int clusterCenterIndex = diffList.indexOf(min);
            Double clusterCenter = this.newClusterCenter.get(clusterCenterIndex);
            this.addPoint2Cluster(point, clusterCenter);
        }
        this.computeClusterCenter();
        if (!this.finish()) {
            this.resetClusterMember();
            this.cluster();
        }
    }

    private boolean finish() {
        if (this.iterateNum > MAX_ITERATE_NUM) {
            this.logger.debug("\u8fed\u4ee3\u6b21\u6570\u5927\u4e8e[{}],\u7ec8\u6b62\u8fed\u4ee3", (Object)this.iterateNum);
            return true;
        }
        for (int i = 0; i < this.numCluster; ++i) {
            double abs = Math.abs(this.newClusterCenter.get(i) - this.oldClusterCenter.get(i));
            if (!(abs > this.errorRange)) continue;
            return false;
        }
        this.logger.debug("\u4e2d\u5fc3\u70b9\u8bef\u5dee\u5c0f\u4e8e[{}],\u7ec8\u6b62\u8fed\u4ee3", (Object)this.errorRange);
        return true;
    }

    private void resetClusterMember() {
        for (Cluster cluster : this.clusterList) {
            cluster.getMembers().clear();
        }
    }

    private void computeClusterCenter() {
        this.oldClusterCenter.clear();
        this.oldClusterCenter.addAll(this.newClusterCenter);
        this.newClusterCenter.clear();
        ArrayList fixCenters = Lists.newArrayList();
        ArrayList memberSize = Lists.newArrayList();
        for (Cluster cluster : this.clusterList) {
            memberSize.add(cluster.getMembers().size());
            if (cluster.getMembers().size() <= this.maxDiscrete) {
                fixCenters.add(cluster.getCenter());
            } else {
                cluster.resetClusterCenter();
            }
            this.newClusterCenter.add(cluster.getCenter());
        }
        Integer maxSize = (Integer)Collections.max(memberSize);
        Cluster maxSizeCluster = this.clusterList.get(memberSize.indexOf(maxSize));
        List<Double> maxSizeMembers = maxSizeCluster.getMembers();
        Double maxPoint = Collections.max(maxSizeMembers);
        Double minPoint = Collections.min(maxSizeMembers);
        double maxSizeCenter = maxSizeCluster.getCenter();
        if (fixCenters.size() != 0) {
            for (Cluster cluster : this.clusterList) {
                if (cluster.getCenter() != ((Double)fixCenters.get(0)).doubleValue()) continue;
                double midPoint = (maxPoint - minPoint) / 2.0;
                cluster.setCenter(midPoint);
                this.newClusterCenter.remove(fixCenters.get(0));
                this.newClusterCenter.add(midPoint);
                break;
            }
        }
        Collections.sort(this.clusterList);
    }

    public void logShowClusterDistribute() {
        for (Cluster cluster : this.clusterList) {
            List<Double> member = cluster.getMembers();
            double center = cluster.getCenter();
            int size = member.size();
            if (size > 2) {
                Double max = Collections.max(member);
                Double min = Collections.min(member);
                Double average = (max - min) / (double)size;
                double standardDiviation = MathUtil.getStandardDiviation(member);
                this.logger.debug("[cluster center:{},size:{},{}~{},average:{},\u6807\u51c6\u5dee:{}]", new Object[]{center, size, min, max, average, standardDiviation});
                continue;
            }
            this.logger.debug("[cluster center:{},size:{}]", (Object)cluster.getCenter(), (Object)size);
        }
    }

    public int getIterateNum() {
        return this.iterateNum;
    }

    public List<Cluster> getClusterList() {
        return this.clusterList;
    }

    public List<KMeansRangeVo> getRanges(String titleTemplate) {
        ArrayList processPrice = Lists.newArrayList();
        processPrice.add(0);
        ArrayList clusterInterval = Lists.newArrayList();
        for (Cluster cluster : this.clusterList) {
            List<Double> members = cluster.getMembers();
            if (members.size() == 0) continue;
            Double max = Collections.max(members);
            Double min = Collections.min(members);
            clusterInterval.add(min / 100.0);
            clusterInterval.add(max / 100.0);
        }
        int i = 1;
        while (i + 1 < clusterInterval.size()) {
            double v = ((Double)clusterInterval.get(i) + (Double)clusterInterval.get(i + 1)) / 2.0;
            int magnitude = String.valueOf((int)v).length() - 1;
            if (magnitude > 2) {
                magnitude = 2;
            }
            int pow = (int)Math.pow(10.0, magnitude);
            int v2 = (int)(Math.round(v / (double)pow) * (long)pow);
            processPrice.add(v2);
            i += 2;
        }
        processPrice.add(Integer.MAX_VALUE);
        ArrayList priceRangeVos = Lists.newArrayList();
        for (int i2 = 0; i2 < processPrice.size() - 1; ++i2) {
            if ((Integer)processPrice.get(i2) >= (Integer)processPrice.get(i2 + 1) - 1) continue;
            KMeansRangeVo priceRangeVo = new KMeansRangeVo((Integer)processPrice.get(i2), (Integer)processPrice.get(i2 + 1) - 1, titleTemplate);
            priceRangeVos.add(priceRangeVo);
        }
        return priceRangeVos;
    }

    private void addPoint2Cluster(Double point, Double clusterCenter) {
        for (Cluster cluster : this.clusterList) {
            if (cluster.getCenter() != clusterCenter.doubleValue()) continue;
            cluster.addPoint(point);
            break;
        }
    }

    public static void main(String[] args) {
        String msg = "1600\u4ee5\u4e0a";
        System.out.println(StringUtils.contains((CharSequence)msg, (CharSequence)"\u4ee5\u4e0a"));
    }
}

