/*
 * Decompiled with CFR 0.152.
 */
package com.biz.primus.common.vo;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class SpringPageVO<T>
implements Serializable {
    private static final long serialVersionUID = -6344449330097328246L;
    private List<T> content = Collections.emptyList();
    private Long totalElements = 0L;
    private Integer size = 0;
    private Integer number = 0;

    public Integer getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil((double)this.totalElements.longValue() / (double)this.getSize().intValue());
    }

    public Boolean hasPrevious() {
        return this.number > 0;
    }

    public Boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public Integer getNumberOfElements() {
        return this.content.size();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public SpringPageVO() {
    }

    @ConstructorProperties(value={"content", "totalElements", "size", "number"})
    public SpringPageVO(List<T> content, Long totalElements, Integer size, Integer number) {
        this.content = content;
        this.totalElements = totalElements;
        this.size = size;
        this.number = number;
    }

    public List<T> getContent() {
        return this.content;
    }

    public Long getTotalElements() {
        return this.totalElements;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public void setTotalElements(Long totalElements) {
        this.totalElements = totalElements;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringPageVO)) {
            return false;
        }
        SpringPageVO other = (SpringPageVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$content = this.getContent();
        List<T> other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        Long this$totalElements = this.getTotalElements();
        Long other$totalElements = other.getTotalElements();
        if (this$totalElements == null ? other$totalElements != null : !((Object)this$totalElements).equals(other$totalElements)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Integer this$number = this.getNumber();
        Integer other$number = other.getNumber();
        return !(this$number == null ? other$number != null : !((Object)this$number).equals(other$number));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpringPageVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        Long $totalElements = this.getTotalElements();
        result = result * 59 + ($totalElements == null ? 43 : ((Object)$totalElements).hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Integer $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
        return result;
    }

    public String toString() {
        return "SpringPageVO(content=" + this.getContent() + ", totalElements=" + this.getTotalElements() + ", size=" + this.getSize() + ", number=" + this.getNumber() + ")";
    }

    public static class Builder<T> {
        SpringPageVO<T> vo = new SpringPageVO();

        public Builder<T> content(List<T> content) {
            this.vo.setContent(content);
            return this;
        }

        public Builder<T> totalElements(Long totalElements) {
            this.vo.setTotalElements(totalElements);
            return this;
        }

        public Builder<T> size(Integer size) {
            this.vo.setSize(size);
            return this;
        }

        public Builder<T> number(Integer number) {
            this.vo.setNumber(number);
            return this;
        }

        public SpringPageVO<T> build() {
            return this.vo;
        }
    }
}

