/*
 * Decompiled with CFR 0.152.
 */
package com.biz.commodity.vo.backend;

import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.commodity.exception.CommodityExceptionType;
import com.biz.commodity.interfaces.Validate;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class GroupProductCreateVo
implements Serializable,
Validate {
    @NotNull
    private String productCode;
    @Size(min=1, message="\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a")
    private @Size(min=1, message="\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a") List<String> itemProductCodes;
    @Size(min=1, message="\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a")
    private @Size(min=1, message="\u7ec4\u5408\u5546\u54c1\u5b50\u5546\u54c1\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a") List<Integer> itemQuantity;
    @Size(min=1, message="\u5b50\u5546\u54c1\u7684\u4ef7\u683c\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a")
    private @Size(min=1, message="\u5b50\u5546\u54c1\u7684\u4ef7\u683c\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a") List<Double> itemPriceFactor;

    @Override
    public void validate() {
        AssertUtils.isTrue((this.itemProductCodes.size() == this.itemQuantity.size() && this.itemQuantity.size() == this.itemPriceFactor.size() ? 1 : 0) != 0, (ExceptionType)CommodityExceptionType.REQUEST_PARAM_EXCEPTION, (String)"\u5b50\u5546\u54c1\u53c2\u6570\u65e0\u6cd5\u5bf9\u5e94");
    }

    public String getProductCode() {
        return this.productCode;
    }

    public List<String> getItemProductCodes() {
        return this.itemProductCodes;
    }

    public List<Integer> getItemQuantity() {
        return this.itemQuantity;
    }

    public List<Double> getItemPriceFactor() {
        return this.itemPriceFactor;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public void setItemProductCodes(List<String> itemProductCodes) {
        this.itemProductCodes = itemProductCodes;
    }

    public void setItemQuantity(List<Integer> itemQuantity) {
        this.itemQuantity = itemQuantity;
    }

    public void setItemPriceFactor(List<Double> itemPriceFactor) {
        this.itemPriceFactor = itemPriceFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupProductCreateVo)) {
            return false;
        }
        GroupProductCreateVo other = (GroupProductCreateVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$productCode = this.getProductCode();
        String other$productCode = other.getProductCode();
        if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
            return false;
        }
        List<String> this$itemProductCodes = this.getItemProductCodes();
        List<String> other$itemProductCodes = other.getItemProductCodes();
        if (this$itemProductCodes == null ? other$itemProductCodes != null : !((Object)this$itemProductCodes).equals(other$itemProductCodes)) {
            return false;
        }
        List<Integer> this$itemQuantity = this.getItemQuantity();
        List<Integer> other$itemQuantity = other.getItemQuantity();
        if (this$itemQuantity == null ? other$itemQuantity != null : !((Object)this$itemQuantity).equals(other$itemQuantity)) {
            return false;
        }
        List<Double> this$itemPriceFactor = this.getItemPriceFactor();
        List<Double> other$itemPriceFactor = other.getItemPriceFactor();
        return !(this$itemPriceFactor == null ? other$itemPriceFactor != null : !((Object)this$itemPriceFactor).equals(other$itemPriceFactor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupProductCreateVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $productCode = this.getProductCode();
        result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
        List<String> $itemProductCodes = this.getItemProductCodes();
        result = result * 59 + ($itemProductCodes == null ? 43 : ((Object)$itemProductCodes).hashCode());
        List<Integer> $itemQuantity = this.getItemQuantity();
        result = result * 59 + ($itemQuantity == null ? 43 : ((Object)$itemQuantity).hashCode());
        List<Double> $itemPriceFactor = this.getItemPriceFactor();
        result = result * 59 + ($itemPriceFactor == null ? 43 : ((Object)$itemPriceFactor).hashCode());
        return result;
    }

    public String toString() {
        return "GroupProductCreateVo(productCode=" + this.getProductCode() + ", itemProductCodes=" + this.getItemProductCodes() + ", itemQuantity=" + this.getItemQuantity() + ", itemPriceFactor=" + this.getItemPriceFactor() + ")";
    }
}

