/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.depot.vo.polygon;

import com.biz.model.depot.vo.polygon.Line;
import com.biz.model.depot.vo.polygon.Point;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Polygon {
    public final BoundingBox _boundingBox;
    private final List<Line> _sides;

    private Polygon(List<Line> sides, BoundingBox boundingBox) {
        this._sides = sides;
        this._boundingBox = boundingBox;
    }

    public static Builder Builder() {
        return new Builder();
    }

    public boolean contains(Point point) {
        if (this.inBoundingBox(point)) {
            Line ray = this.createRay(point);
            int intersection = 0;
            for (Line side : this._sides) {
                if (!this.intersect(ray, side)) continue;
                ++intersection;
            }
            if (intersection % 2 == 1) {
                return true;
            }
        }
        return false;
    }

    public List<Line> getSides() {
        return this._sides;
    }

    private boolean intersect(Line ray, Line side) {
        Point intersectPoint = null;
        if (!ray.isVertical() && !side.isVertical()) {
            if (ray.getA() - side.getA() == 0.0) {
                return false;
            }
            double x = (side.getB() - ray.getB()) / (ray.getA() - side.getA());
            double y = side.getA() * x + side.getB();
            intersectPoint = new Point(x, y);
        } else if (ray.isVertical() && !side.isVertical()) {
            double x = ray.getStart().getX();
            double y = side.getA() * x + side.getB();
            intersectPoint = new Point(x, y);
        } else if (!ray.isVertical() && side.isVertical()) {
            double x = side.getStart().getX();
            double y = ray.getA() * x + ray.getB();
            intersectPoint = new Point(x, y);
        } else {
            return false;
        }
        return side.isInside(intersectPoint) && ray.isInside(intersectPoint);
    }

    private Line createRay(Point point) {
        double epsilon = (this._boundingBox.xMax - this._boundingBox.xMin) / 100.0;
        Point outsidePoint = new Point(this._boundingBox.xMin - epsilon, this._boundingBox.yMin);
        Line vector = new Line(outsidePoint, point);
        return vector;
    }

    private boolean inBoundingBox(Point point) {
        return !(point.getX() < this._boundingBox.xMin || point.getX() > this._boundingBox.xMax || point.getY() < this._boundingBox.yMin) && !(point.getY() > this._boundingBox.yMax);
    }

    public static class BoundingBox {
        private double xMax = Double.NEGATIVE_INFINITY;
        private double xMin = Double.NEGATIVE_INFINITY;
        private double yMax = Double.NEGATIVE_INFINITY;
        private double yMin = Double.NEGATIVE_INFINITY;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    public static class Builder {
        private List<Point> _vertexes = new ArrayList<Point>();
        private List<Line> _sides = new ArrayList<Line>();
        private BoundingBox _boundingBox = null;
        private boolean _firstPoint = true;
        private boolean _isClosed = false;

        public Builder addVertex(Point point) {
            if (this._isClosed) {
                this._vertexes = new ArrayList<Point>();
                this._isClosed = false;
            }
            this.updateBoundingBox(point);
            this._vertexes.add(point);
            if (this._vertexes.size() > 1) {
                Line Line2 = new Line(this._vertexes.get(this._vertexes.size() - 2), point);
                this._sides.add(Line2);
            }
            return this;
        }

        public Builder close() {
            this.validate();
            this._sides.add(new Line(this._vertexes.get(this._vertexes.size() - 1), this._vertexes.get(0)));
            this._isClosed = true;
            return this;
        }

        public Polygon build() {
            this.validate();
            if (!this._isClosed) {
                this._sides.add(new Line(this._vertexes.get(this._vertexes.size() - 1), this._vertexes.get(0)));
            }
            Polygon polygon = new Polygon(this._sides, this._boundingBox);
            return polygon;
        }

        private void updateBoundingBox(Point point) {
            if (this._firstPoint) {
                this._boundingBox = new BoundingBox();
                this._boundingBox.xMax = point.getX();
                this._boundingBox.xMin = point.getX();
                this._boundingBox.yMax = point.getY();
                this._boundingBox.yMin = point.getY();
                this._firstPoint = false;
            } else {
                if (point.getX() > this._boundingBox.xMax) {
                    this._boundingBox.xMax = point.getX();
                } else if (point.getX() < this._boundingBox.xMin) {
                    this._boundingBox.xMin = point.getX();
                }
                if (point.getY() > this._boundingBox.yMax) {
                    this._boundingBox.yMax = point.getY();
                } else if (point.getY() < this._boundingBox.yMin) {
                    this._boundingBox.yMin = point.getY();
                }
            }
        }

        private void validate() {
            if (this._vertexes.size() < 3) {
                throw new RuntimeException("Polygon must have at least 3 points");
            }
        }
    }
}

