/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.depot.vo.polygon;

import com.biz.model.depot.vo.polygon.Point;

public class Line {
    private final Point _start;
    private final Point _end;
    private double _a = Double.NaN;
    private double _b = Double.NaN;
    private boolean _vertical = false;

    public Line(Point start, Point end) {
        this._start = start;
        this._end = end;
        if (this._end.getX() - this._start.getX() != 0.0) {
            this._a = (this._end.getY() - this._start.getY()) / (this._end.getX() - this._start.getX());
            this._b = this._start.getY() - this._a * this._start.getX();
        } else {
            this._vertical = true;
        }
    }

    public boolean isInside(Point point) {
        double minY;
        double maxX = this._start.getX() > this._end.getX() ? this._start.getX() : this._end.getX();
        double minX = this._start.getX() < this._end.getX() ? this._start.getX() : this._end.getX();
        double maxY = this._start.getY() > this._end.getY() ? this._start.getY() : this._end.getY();
        double d = minY = this._start.getY() < this._end.getY() ? this._start.getY() : this._end.getY();
        return point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY;
    }

    public boolean isVertical() {
        return this._vertical;
    }

    public double getA() {
        return this._a;
    }

    public double getB() {
        return this._b;
    }

    public Point getStart() {
        return this._start;
    }

    public Point getEnd() {
        return this._end;
    }

    public String toString() {
        return String.format("%s-%s", this._start.toString(), this._end.toString());
    }
}

