/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.depot.lang;

import com.biz.base.exception.BizBusinessException;
import com.biz.base.exception.ExceptionType;
import com.biz.model.depot.lang.SubscribeException;
import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXBizMsgCrypt {
    private static final Logger log = LoggerFactory.getLogger(WXBizMsgCrypt.class);
    static Charset CHARSET = Charset.forName("utf-8");
    private Base64 base64 = new Base64();
    private byte[] aesKey;
    private String token;
    private String appId;

    public WXBizMsgCrypt(String token, String encodingAesKey, String appId) {
        if (encodingAesKey.length() != 43) {
            throw new BizBusinessException((ExceptionType)SubscribeException.ILLEGAL_AES_KEY);
        }
        this.token = token;
        this.appId = appId;
        this.aesKey = Base64.decodeBase64((String)(encodingAesKey + "="));
    }

    private byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    private int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }
}

