/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.misc.vo;

import com.biz.model.misc.enums.MessageType;
import com.biz.model.misc.enums.SignaturePosition;
import com.biz.model.misc.utils.MessageTextUtils;
import com.biz.model.misc.vo.ChannelBasedAuth;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

public abstract class SendRequestVo
extends ChannelBasedAuth {
    private static final long serialVersionUID = -8147703800907893269L;
    @JsonIgnore
    private String signature = "\u5ddd\u9152\u79d1\u6280";
    @ApiModelProperty(value="\u6a21\u677fid")
    private String templateId;
    private String content;
    private MessageType type = MessageType.auto;
    private SignaturePosition signaturePosition = SignaturePosition.head;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date expireAt;

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public SignaturePosition getSignaturePosition() {
        return this.signaturePosition;
    }

    public void setSignaturePosition(SignaturePosition signaturePosition) {
        this.signaturePosition = signaturePosition;
    }

    public Date getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    public MessageType getType() {
        if (this.type == MessageType.auto) {
            return this.content.matches("^\\d{5,}$") ? MessageType.validcode : MessageType.notice;
        }
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    @JsonIgnore
    public String getFullText() {
        return MessageTextUtils.getMessageFullText(this.signaturePosition, this.signature, this.content);
    }
}

