/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.misc.utils;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static SSLConnectionSocketFactory trustAllSSLConnectionSocketFactory = HttpUtils.createTrustAllSSLConnectionSocketFactory();

    public static String executePostRequest(HttpUriRequest req) throws HttpException {
        return HttpUtils.executePostRequestInternal(req, 0);
    }

    public static String executePostRequestInRetry(HttpUriRequest req, int retryCount) throws HttpException {
        return HttpUtils.executePostRequestInternal(req, retryCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String executePostRequestInternal(HttpUriRequest req, int retryCount) throws HttpException {
        try (CloseableHttpClient client = HttpUtils.createSSLClient();){
            long begin = System.currentTimeMillis();
            CloseableHttpResponse resp = client.execute(req);
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode >= 300) {
                throw new HttpException("http\u63a5\u53e3\u4e0d\u53ef\u7528,\u8fd4\u56de\u72b6\u6001:" + statusCode);
            }
            HttpEntity entity = resp.getEntity();
            long end = System.currentTimeMillis();
            log.info("exec http request ms={},uri={}", (Object)(end - begin), (Object)req.getURI());
            String string = EntityUtils.toString((HttpEntity)entity);
            return string;
        }
        catch (IOException e) {
            if (retryCount < 2) {
                log.error("execute http request error, retry count = {}", (Object)retryCount, (Object)e);
                return HttpUtils.executePostRequestInternal(req, ++retryCount);
            }
            log.error("com.biz.model.misc.utils.HttpUtils.executePostRequestInternal error:", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static CloseableHttpClient createSSLClient() {
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)trustAllSSLConnectionSocketFactory).build();
    }

    private static SSLConnectionSocketFactory createTrustAllSSLConnectionSocketFactory() {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

