/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.oms.vo.export;

import com.biz.primus.common.enums.DescribableEnum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public interface ExportableField {
    public FormatType getFormatType();

    public static enum FormatType {
        none,
        amount,
        date,
        number,
        enums;

        private static FastDateFormat fastDateFormat;
        private static DateTimeFormatter dateTimeFormatter;

        public Object format(Object val, String pattern) {
            if (val != null) {
                switch (this) {
                    case enums: {
                        if (val instanceof DescribableEnum) {
                            return ((DescribableEnum)val).getDesc();
                        }
                        throw new IllegalStateException("\u6807\u8bb0\u683c\u5f0f\u5316\u7c7b\u578b\u4e3aenums\u7684\u5b57\u6bb5,\u5176\u7c7b\u578b\u6ca1\u6709\u5b9e\u73b0com.biz.primus.common.enums.DescribableEnum\u63a5\u53e3, val=" + val + ",type=" + val.getClass());
                    }
                    case none: {
                        return val;
                    }
                    case number: {
                        return val;
                    }
                    case amount: {
                        return new BigDecimal(val.toString()).movePointLeft(2);
                    }
                    case date: {
                        if (val instanceof Date) {
                            return fastDateFormat.format(val);
                        }
                        if (val instanceof Temporal) {
                            return dateTimeFormatter.format((Temporal)val);
                        }
                        if (val instanceof Long) {
                            return fastDateFormat.format((Date)new Timestamp((Long)val));
                        }
                        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b:" + val.getClass());
                    }
                }
                throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u683c\u5f0f\u5316\u7c7b\u578b:" + (Object)((Object)this));
            }
            return null;
        }

        public Object format(Object val) {
            return this.format(val, null);
        }

        static {
            fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
            dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        }
    }
}

