/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.oms.vo.export;

import com.biz.model.oms.enums.OmsExportField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellData {
    private static final Logger log = LoggerFactory.getLogger(CellData.class);
    private Object value;
    private boolean expandable;
    private OmsExportField field;

    public CellData(Object value, OmsExportField field) {
        this(value, field, value instanceof Collection);
    }

    public CellData(Object value, OmsExportField field, boolean expandable) {
        this.field = field;
        this.expandable = expandable;
        this.value = expandable ? value : field.getFormatType().format(value);
    }

    @JsonIgnore
    public Object getFormatedValue() {
        return this.value;
    }

    @JsonIgnore
    public List<Object> getExpandableData() {
        if (this.expandable) {
            return (List)this.value;
        }
        return Collections.emptyList();
    }

    public CellData() {
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public OmsExportField getField() {
        return this.field;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public void setField(OmsExportField field) {
        this.field = field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellData)) {
            return false;
        }
        CellData other = (CellData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.isExpandable() != other.isExpandable()) {
            return false;
        }
        OmsExportField this$field = this.getField();
        OmsExportField other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CellData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isExpandable() ? 79 : 97);
        OmsExportField $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public String toString() {
        return "CellData(value=" + this.getValue() + ", expandable=" + this.isExpandable() + ", field=" + this.getField() + ")";
    }
}

