/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.oms.stream;

import com.biz.model.oms.enums.OrderDeliveryType;
import com.biz.model.oms.vo.OmsConsigneeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;

public interface OrderStateChannel {
    public static final String ORDER_CANCEL = "oms-order-cancel";
    public static final String ORDER_DELIVERY_BEGIN = "oms-order-delivery-begin";
    public static final String ORDER_DELIVERY_CANCEL = "oms-order-delivery-cancel";
    public static final String ORDER_BEGIN = "oms-order-begin";
    public static final String ORDER_ALLOCATED = "oms-order-allocated";
    public static final String ORDER_PRINTED = "oms-order-printed";
    public static final String ORDER_OUTBOUND = "oms-order-outbound";
    public static final String ORDER_FINISHED = "oms-order-finished";
    public static final String ORDER_STATE_CHANGE = "oms-order-state-change";
    public static final String ORDER_ALLOCATION_DEPOT = "oms-order-allocation-depot";
    public static final String ORDER_FILL_EXPRESS = "oms-order-fill-express";
    public static final String ORDER_CONSIGNEE_CHANGE = "oms-order-consignee-change";
    public static final String ORDER_SPLIT_NOTICE = "oms-order-split";
    public static final String ORDER_REPUSH_ERP_BRIDGE = "order-repush-erp-bridge";
    public static final String ORDER_PUSH_WMS_FOR_OUTPUT = "order-push-wms-for-output";
    public static final String ORDER_PUSH_POS_FOR_OUTPUT = "order-push-pos-for-output";

    @ApiModel(value="\u8ba2\u5355\u6536\u8d27\u4eba\u4fe1\u606f\u53d8\u66f4\u65f6, \u63a8\u9001\u7684\u901a\u77e5")
    public static class ConsigneeChangeNotice {
        @ApiModelProperty(value="\u65b0\u7684\u6536\u8d27\u4eba\u4fe1\u606f")
        OmsConsigneeVo consignee;
        @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7")
        String orderCode;
        @ApiModelProperty(value="\u7528\u6237id")
        Long userId;
        @ApiModelProperty(value="\u95e8\u5e97\u7f16\u53f7")
        String depotCode;

        public static ConsigneeChangeNoticeBuilder builder() {
            return new ConsigneeChangeNoticeBuilder();
        }

        public OmsConsigneeVo getConsignee() {
            return this.consignee;
        }

        public String getOrderCode() {
            return this.orderCode;
        }

        public Long getUserId() {
            return this.userId;
        }

        public String getDepotCode() {
            return this.depotCode;
        }

        public void setConsignee(OmsConsigneeVo consignee) {
            this.consignee = consignee;
        }

        public void setOrderCode(String orderCode) {
            this.orderCode = orderCode;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public void setDepotCode(String depotCode) {
            this.depotCode = depotCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsigneeChangeNotice)) {
                return false;
            }
            ConsigneeChangeNotice other = (ConsigneeChangeNotice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            OmsConsigneeVo this$consignee = this.getConsignee();
            OmsConsigneeVo other$consignee = other.getConsignee();
            if (this$consignee == null ? other$consignee != null : !((Object)this$consignee).equals(other$consignee)) {
                return false;
            }
            String this$orderCode = this.getOrderCode();
            String other$orderCode = other.getOrderCode();
            if (this$orderCode == null ? other$orderCode != null : !this$orderCode.equals(other$orderCode)) {
                return false;
            }
            Long this$userId = this.getUserId();
            Long other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
                return false;
            }
            String this$depotCode = this.getDepotCode();
            String other$depotCode = other.getDepotCode();
            return !(this$depotCode == null ? other$depotCode != null : !this$depotCode.equals(other$depotCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConsigneeChangeNotice;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            OmsConsigneeVo $consignee = this.getConsignee();
            result = result * 59 + ($consignee == null ? 43 : ((Object)$consignee).hashCode());
            String $orderCode = this.getOrderCode();
            result = result * 59 + ($orderCode == null ? 43 : $orderCode.hashCode());
            Long $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            String $depotCode = this.getDepotCode();
            result = result * 59 + ($depotCode == null ? 43 : $depotCode.hashCode());
            return result;
        }

        public String toString() {
            return "OrderStateChannel.ConsigneeChangeNotice(consignee=" + this.getConsignee() + ", orderCode=" + this.getOrderCode() + ", userId=" + this.getUserId() + ", depotCode=" + this.getDepotCode() + ")";
        }

        public ConsigneeChangeNotice() {
        }

        @ConstructorProperties(value={"consignee", "orderCode", "userId", "depotCode"})
        public ConsigneeChangeNotice(OmsConsigneeVo consignee, String orderCode, Long userId, String depotCode) {
            this.consignee = consignee;
            this.orderCode = orderCode;
            this.userId = userId;
            this.depotCode = depotCode;
        }

        public static class ConsigneeChangeNoticeBuilder {
            private OmsConsigneeVo consignee;
            private String orderCode;
            private Long userId;
            private String depotCode;

            ConsigneeChangeNoticeBuilder() {
            }

            public ConsigneeChangeNoticeBuilder consignee(OmsConsigneeVo consignee) {
                this.consignee = consignee;
                return this;
            }

            public ConsigneeChangeNoticeBuilder orderCode(String orderCode) {
                this.orderCode = orderCode;
                return this;
            }

            public ConsigneeChangeNoticeBuilder userId(Long userId) {
                this.userId = userId;
                return this;
            }

            public ConsigneeChangeNoticeBuilder depotCode(String depotCode) {
                this.depotCode = depotCode;
                return this;
            }

            public ConsigneeChangeNotice build() {
                return new ConsigneeChangeNotice(this.consignee, this.orderCode, this.userId, this.depotCode);
            }

            public String toString() {
                return "OrderStateChannel.ConsigneeChangeNotice.ConsigneeChangeNoticeBuilder(consignee=" + this.consignee + ", orderCode=" + this.orderCode + ", userId=" + this.userId + ", depotCode=" + this.depotCode + ")";
            }
        }
    }

    @ApiModel(value="\u8ba2\u5355\u95e8\u5e97\u6539\u6d3e\u8bf7\u6c42")
    public static class OrderAllocationDepotRequest {
        @ApiModelProperty(value="\u8ba2\u5355\u7f16\u7801")
        String orderCode;
        @ApiModelProperty(value="\u5206\u914d\u7684\u76ee\u6807\u95e8\u5e97")
        String targetDepotCode;
        @ApiModelProperty(value="\u5206\u914d\u7684\u76ee\u6807\u95e8\u5e97\u540d\u79f0")
        String targetDepotName;

        public static OrderAllocationDepotRequestBuilder builder() {
            return new OrderAllocationDepotRequestBuilder();
        }

        public String getOrderCode() {
            return this.orderCode;
        }

        public String getTargetDepotCode() {
            return this.targetDepotCode;
        }

        public String getTargetDepotName() {
            return this.targetDepotName;
        }

        public void setOrderCode(String orderCode) {
            this.orderCode = orderCode;
        }

        public void setTargetDepotCode(String targetDepotCode) {
            this.targetDepotCode = targetDepotCode;
        }

        public void setTargetDepotName(String targetDepotName) {
            this.targetDepotName = targetDepotName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderAllocationDepotRequest)) {
                return false;
            }
            OrderAllocationDepotRequest other = (OrderAllocationDepotRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orderCode = this.getOrderCode();
            String other$orderCode = other.getOrderCode();
            if (this$orderCode == null ? other$orderCode != null : !this$orderCode.equals(other$orderCode)) {
                return false;
            }
            String this$targetDepotCode = this.getTargetDepotCode();
            String other$targetDepotCode = other.getTargetDepotCode();
            if (this$targetDepotCode == null ? other$targetDepotCode != null : !this$targetDepotCode.equals(other$targetDepotCode)) {
                return false;
            }
            String this$targetDepotName = this.getTargetDepotName();
            String other$targetDepotName = other.getTargetDepotName();
            return !(this$targetDepotName == null ? other$targetDepotName != null : !this$targetDepotName.equals(other$targetDepotName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderAllocationDepotRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orderCode = this.getOrderCode();
            result = result * 59 + ($orderCode == null ? 43 : $orderCode.hashCode());
            String $targetDepotCode = this.getTargetDepotCode();
            result = result * 59 + ($targetDepotCode == null ? 43 : $targetDepotCode.hashCode());
            String $targetDepotName = this.getTargetDepotName();
            result = result * 59 + ($targetDepotName == null ? 43 : $targetDepotName.hashCode());
            return result;
        }

        public String toString() {
            return "OrderStateChannel.OrderAllocationDepotRequest(orderCode=" + this.getOrderCode() + ", targetDepotCode=" + this.getTargetDepotCode() + ", targetDepotName=" + this.getTargetDepotName() + ")";
        }

        public OrderAllocationDepotRequest() {
        }

        @ConstructorProperties(value={"orderCode", "targetDepotCode", "targetDepotName"})
        public OrderAllocationDepotRequest(String orderCode, String targetDepotCode, String targetDepotName) {
            this.orderCode = orderCode;
            this.targetDepotCode = targetDepotCode;
            this.targetDepotName = targetDepotName;
        }

        public static class OrderAllocationDepotRequestBuilder {
            private String orderCode;
            private String targetDepotCode;
            private String targetDepotName;

            OrderAllocationDepotRequestBuilder() {
            }

            public OrderAllocationDepotRequestBuilder orderCode(String orderCode) {
                this.orderCode = orderCode;
                return this;
            }

            public OrderAllocationDepotRequestBuilder targetDepotCode(String targetDepotCode) {
                this.targetDepotCode = targetDepotCode;
                return this;
            }

            public OrderAllocationDepotRequestBuilder targetDepotName(String targetDepotName) {
                this.targetDepotName = targetDepotName;
                return this;
            }

            public OrderAllocationDepotRequest build() {
                return new OrderAllocationDepotRequest(this.orderCode, this.targetDepotCode, this.targetDepotName);
            }

            public String toString() {
                return "OrderStateChannel.OrderAllocationDepotRequest.OrderAllocationDepotRequestBuilder(orderCode=" + this.orderCode + ", targetDepotCode=" + this.targetDepotCode + ", targetDepotName=" + this.targetDepotName + ")";
            }
        }
    }

    public static class FillExpressInfoData {
        private String orderCode;
        private String expressProvider;
        private String expressNumber;
        private String operator;

        public String getOrderCode() {
            return this.orderCode;
        }

        public String getExpressProvider() {
            return this.expressProvider;
        }

        public String getExpressNumber() {
            return this.expressNumber;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOrderCode(String orderCode) {
            this.orderCode = orderCode;
        }

        public void setExpressProvider(String expressProvider) {
            this.expressProvider = expressProvider;
        }

        public void setExpressNumber(String expressNumber) {
            this.expressNumber = expressNumber;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FillExpressInfoData)) {
                return false;
            }
            FillExpressInfoData other = (FillExpressInfoData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orderCode = this.getOrderCode();
            String other$orderCode = other.getOrderCode();
            if (this$orderCode == null ? other$orderCode != null : !this$orderCode.equals(other$orderCode)) {
                return false;
            }
            String this$expressProvider = this.getExpressProvider();
            String other$expressProvider = other.getExpressProvider();
            if (this$expressProvider == null ? other$expressProvider != null : !this$expressProvider.equals(other$expressProvider)) {
                return false;
            }
            String this$expressNumber = this.getExpressNumber();
            String other$expressNumber = other.getExpressNumber();
            if (this$expressNumber == null ? other$expressNumber != null : !this$expressNumber.equals(other$expressNumber)) {
                return false;
            }
            String this$operator = this.getOperator();
            String other$operator = other.getOperator();
            return !(this$operator == null ? other$operator != null : !this$operator.equals(other$operator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FillExpressInfoData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orderCode = this.getOrderCode();
            result = result * 59 + ($orderCode == null ? 43 : $orderCode.hashCode());
            String $expressProvider = this.getExpressProvider();
            result = result * 59 + ($expressProvider == null ? 43 : $expressProvider.hashCode());
            String $expressNumber = this.getExpressNumber();
            result = result * 59 + ($expressNumber == null ? 43 : $expressNumber.hashCode());
            String $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            return result;
        }

        public String toString() {
            return "OrderStateChannel.FillExpressInfoData(orderCode=" + this.getOrderCode() + ", expressProvider=" + this.getExpressProvider() + ", expressNumber=" + this.getExpressNumber() + ", operator=" + this.getOperator() + ")";
        }

        @ConstructorProperties(value={"orderCode", "expressProvider", "expressNumber", "operator"})
        public FillExpressInfoData(String orderCode, String expressProvider, String expressNumber, String operator) {
            this.orderCode = orderCode;
            this.expressProvider = expressProvider;
            this.expressNumber = expressNumber;
            this.operator = operator;
        }

        public FillExpressInfoData() {
        }
    }

    public static class OrderStateNoticeData {
        private String orderCode;
        private String depotCode;
        private Long userId;
        private String channel;
        private OrderDeliveryType deliveryType;
        private String expectedDepotCode;
        private String sourceOrderCode;

        public static OrderStateNoticeDataBuilder builder() {
            return new OrderStateNoticeDataBuilder();
        }

        public String getOrderCode() {
            return this.orderCode;
        }

        public String getDepotCode() {
            return this.depotCode;
        }

        public Long getUserId() {
            return this.userId;
        }

        public String getChannel() {
            return this.channel;
        }

        public OrderDeliveryType getDeliveryType() {
            return this.deliveryType;
        }

        public String getExpectedDepotCode() {
            return this.expectedDepotCode;
        }

        public String getSourceOrderCode() {
            return this.sourceOrderCode;
        }

        public void setOrderCode(String orderCode) {
            this.orderCode = orderCode;
        }

        public void setDepotCode(String depotCode) {
            this.depotCode = depotCode;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public void setDeliveryType(OrderDeliveryType deliveryType) {
            this.deliveryType = deliveryType;
        }

        public void setExpectedDepotCode(String expectedDepotCode) {
            this.expectedDepotCode = expectedDepotCode;
        }

        public void setSourceOrderCode(String sourceOrderCode) {
            this.sourceOrderCode = sourceOrderCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderStateNoticeData)) {
                return false;
            }
            OrderStateNoticeData other = (OrderStateNoticeData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orderCode = this.getOrderCode();
            String other$orderCode = other.getOrderCode();
            if (this$orderCode == null ? other$orderCode != null : !this$orderCode.equals(other$orderCode)) {
                return false;
            }
            String this$depotCode = this.getDepotCode();
            String other$depotCode = other.getDepotCode();
            if (this$depotCode == null ? other$depotCode != null : !this$depotCode.equals(other$depotCode)) {
                return false;
            }
            Long this$userId = this.getUserId();
            Long other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
                return false;
            }
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            OrderDeliveryType this$deliveryType = this.getDeliveryType();
            OrderDeliveryType other$deliveryType = other.getDeliveryType();
            if (this$deliveryType == null ? other$deliveryType != null : !((Object)((Object)this$deliveryType)).equals((Object)other$deliveryType)) {
                return false;
            }
            String this$expectedDepotCode = this.getExpectedDepotCode();
            String other$expectedDepotCode = other.getExpectedDepotCode();
            if (this$expectedDepotCode == null ? other$expectedDepotCode != null : !this$expectedDepotCode.equals(other$expectedDepotCode)) {
                return false;
            }
            String this$sourceOrderCode = this.getSourceOrderCode();
            String other$sourceOrderCode = other.getSourceOrderCode();
            return !(this$sourceOrderCode == null ? other$sourceOrderCode != null : !this$sourceOrderCode.equals(other$sourceOrderCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderStateNoticeData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orderCode = this.getOrderCode();
            result = result * 59 + ($orderCode == null ? 43 : $orderCode.hashCode());
            String $depotCode = this.getDepotCode();
            result = result * 59 + ($depotCode == null ? 43 : $depotCode.hashCode());
            Long $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            OrderDeliveryType $deliveryType = this.getDeliveryType();
            result = result * 59 + ($deliveryType == null ? 43 : ((Object)((Object)$deliveryType)).hashCode());
            String $expectedDepotCode = this.getExpectedDepotCode();
            result = result * 59 + ($expectedDepotCode == null ? 43 : $expectedDepotCode.hashCode());
            String $sourceOrderCode = this.getSourceOrderCode();
            result = result * 59 + ($sourceOrderCode == null ? 43 : $sourceOrderCode.hashCode());
            return result;
        }

        public String toString() {
            return "OrderStateChannel.OrderStateNoticeData(orderCode=" + this.getOrderCode() + ", depotCode=" + this.getDepotCode() + ", userId=" + this.getUserId() + ", channel=" + this.getChannel() + ", deliveryType=" + (Object)((Object)this.getDeliveryType()) + ", expectedDepotCode=" + this.getExpectedDepotCode() + ", sourceOrderCode=" + this.getSourceOrderCode() + ")";
        }

        public OrderStateNoticeData() {
        }

        @ConstructorProperties(value={"orderCode", "depotCode", "userId", "channel", "deliveryType", "expectedDepotCode", "sourceOrderCode"})
        public OrderStateNoticeData(String orderCode, String depotCode, Long userId, String channel, OrderDeliveryType deliveryType, String expectedDepotCode, String sourceOrderCode) {
            this.orderCode = orderCode;
            this.depotCode = depotCode;
            this.userId = userId;
            this.channel = channel;
            this.deliveryType = deliveryType;
            this.expectedDepotCode = expectedDepotCode;
            this.sourceOrderCode = sourceOrderCode;
        }

        public static class OrderStateNoticeDataBuilder {
            private String orderCode;
            private String depotCode;
            private Long userId;
            private String channel;
            private OrderDeliveryType deliveryType;
            private String expectedDepotCode;
            private String sourceOrderCode;

            OrderStateNoticeDataBuilder() {
            }

            public OrderStateNoticeDataBuilder orderCode(String orderCode) {
                this.orderCode = orderCode;
                return this;
            }

            public OrderStateNoticeDataBuilder depotCode(String depotCode) {
                this.depotCode = depotCode;
                return this;
            }

            public OrderStateNoticeDataBuilder userId(Long userId) {
                this.userId = userId;
                return this;
            }

            public OrderStateNoticeDataBuilder channel(String channel) {
                this.channel = channel;
                return this;
            }

            public OrderStateNoticeDataBuilder deliveryType(OrderDeliveryType deliveryType) {
                this.deliveryType = deliveryType;
                return this;
            }

            public OrderStateNoticeDataBuilder expectedDepotCode(String expectedDepotCode) {
                this.expectedDepotCode = expectedDepotCode;
                return this;
            }

            public OrderStateNoticeDataBuilder sourceOrderCode(String sourceOrderCode) {
                this.sourceOrderCode = sourceOrderCode;
                return this;
            }

            public OrderStateNoticeData build() {
                return new OrderStateNoticeData(this.orderCode, this.depotCode, this.userId, this.channel, this.deliveryType, this.expectedDepotCode, this.sourceOrderCode);
            }

            public String toString() {
                return "OrderStateChannel.OrderStateNoticeData.OrderStateNoticeDataBuilder(orderCode=" + this.orderCode + ", depotCode=" + this.depotCode + ", userId=" + this.userId + ", channel=" + this.channel + ", deliveryType=" + (Object)((Object)this.deliveryType) + ", expectedDepotCode=" + this.expectedDepotCode + ", sourceOrderCode=" + this.sourceOrderCode + ")";
            }
        }
    }

    public static class OrderSplitNotice {
        String orderCode;
        String sourceOrderCode;
        String depotCode;

        public static OrderSplitNoticeBuilder builder() {
            return new OrderSplitNoticeBuilder();
        }

        public String getOrderCode() {
            return this.orderCode;
        }

        public String getSourceOrderCode() {
            return this.sourceOrderCode;
        }

        public String getDepotCode() {
            return this.depotCode;
        }

        public void setOrderCode(String orderCode) {
            this.orderCode = orderCode;
        }

        public void setSourceOrderCode(String sourceOrderCode) {
            this.sourceOrderCode = sourceOrderCode;
        }

        public void setDepotCode(String depotCode) {
            this.depotCode = depotCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderSplitNotice)) {
                return false;
            }
            OrderSplitNotice other = (OrderSplitNotice)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orderCode = this.getOrderCode();
            String other$orderCode = other.getOrderCode();
            if (this$orderCode == null ? other$orderCode != null : !this$orderCode.equals(other$orderCode)) {
                return false;
            }
            String this$sourceOrderCode = this.getSourceOrderCode();
            String other$sourceOrderCode = other.getSourceOrderCode();
            if (this$sourceOrderCode == null ? other$sourceOrderCode != null : !this$sourceOrderCode.equals(other$sourceOrderCode)) {
                return false;
            }
            String this$depotCode = this.getDepotCode();
            String other$depotCode = other.getDepotCode();
            return !(this$depotCode == null ? other$depotCode != null : !this$depotCode.equals(other$depotCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderSplitNotice;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orderCode = this.getOrderCode();
            result = result * 59 + ($orderCode == null ? 43 : $orderCode.hashCode());
            String $sourceOrderCode = this.getSourceOrderCode();
            result = result * 59 + ($sourceOrderCode == null ? 43 : $sourceOrderCode.hashCode());
            String $depotCode = this.getDepotCode();
            result = result * 59 + ($depotCode == null ? 43 : $depotCode.hashCode());
            return result;
        }

        public String toString() {
            return "OrderStateChannel.OrderSplitNotice(orderCode=" + this.getOrderCode() + ", sourceOrderCode=" + this.getSourceOrderCode() + ", depotCode=" + this.getDepotCode() + ")";
        }

        public OrderSplitNotice() {
        }

        @ConstructorProperties(value={"orderCode", "sourceOrderCode", "depotCode"})
        public OrderSplitNotice(String orderCode, String sourceOrderCode, String depotCode) {
            this.orderCode = orderCode;
            this.sourceOrderCode = sourceOrderCode;
            this.depotCode = depotCode;
        }

        public static class OrderSplitNoticeBuilder {
            private String orderCode;
            private String sourceOrderCode;
            private String depotCode;

            OrderSplitNoticeBuilder() {
            }

            public OrderSplitNoticeBuilder orderCode(String orderCode) {
                this.orderCode = orderCode;
                return this;
            }

            public OrderSplitNoticeBuilder sourceOrderCode(String sourceOrderCode) {
                this.sourceOrderCode = sourceOrderCode;
                return this;
            }

            public OrderSplitNoticeBuilder depotCode(String depotCode) {
                this.depotCode = depotCode;
                return this;
            }

            public OrderSplitNotice build() {
                return new OrderSplitNotice(this.orderCode, this.sourceOrderCode, this.depotCode);
            }

            public String toString() {
                return "OrderStateChannel.OrderSplitNotice.OrderSplitNoticeBuilder(orderCode=" + this.orderCode + ", sourceOrderCode=" + this.sourceOrderCode + ", depotCode=" + this.depotCode + ")";
            }
        }
    }
}

