/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.pos.enums;

import com.biz.primus.common.enums.EnumerableValue;
import com.biz.primus.common.enums.converter.BaseEnumValueConverter;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OrderState implements EnumerableValue
{
    WAIT_PAY(-1, "\u5f85\u4ed8\u6b3e"),
    WAIT_SEND(0, "\u5f85\u53d1\u8d27"),
    WAIT_RECEIVE(5, "\u5f85\u6536\u8d27"),
    WAIT_EVALUATION(10, "\u5f85\u8bc4\u4ef7"),
    FINISHED(20, "\u8ba2\u5355\u5b8c\u6210"),
    CANCELED(30, "\u5df2\u53d6\u6d88"),
    AFTER_SALE(50, "\u552e\u540e\u4e2d"),
    FINISHED_AFTER_SALE(55, "\u552e\u540e\u5b8c\u6210");

    public final int value;
    public final String desc;

    private OrderState(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getValue() {
        return this.value;
    }

    public static OrderState getByValue(int value) {
        for (OrderState orderState : OrderState.values()) {
            if (value != orderState.value) continue;
            return orderState;
        }
        return null;
    }

    public static Map<String, String> toMap() {
        return Arrays.stream(OrderState.values()).collect(Collectors.toMap(Enum::name, OrderState::getDesc));
    }

    public static class Converter
    extends BaseEnumValueConverter<OrderState> {
    }
}

