/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.price.vo;

import com.biz.base.constant.Constant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="\u7ec4\u5408\u5546\u54c1\u4ef7\u683c\u8bbe\u7f6evo")
public class GroupProductPriceVo {
    private static final Logger log = LoggerFactory.getLogger(GroupProductPriceVo.class);
    @ApiModelProperty(value="\u5546\u54c1\u7f16\u7801")
    private String productCode;
    @ApiModelProperty(value="\u4f1a\u5458\u5212\u7ebf\u4ef7")
    private Integer normalPrice;
    @ApiModelProperty(value="\u4f1a\u5458\u4ef7")
    private Integer finalPrice;
    @ApiModelProperty(value="\u6574\u7bb1\u5355\u74f6\u4ef7 \u65e0\u6548 \u4f7f\u7528\u4f1a\u5458\u4ef7")
    private Integer fclSinglePrice;
    @ApiModelProperty(value="\u7535\u5b50\u94b1\u5305\u4ef7 \u65e0\u6548 \u4f7f\u7528\u4f1a\u5458\u4ef7")
    private Integer ewalletPrice;

    public Boolean valid() {
        if (StringUtils.isBlank((CharSequence)this.productCode) || !this.productCode.startsWith("ZH")) {
            log.warn("\u7ec4\u5408\u5546\u54c1\u7f16\u7801\u4e0d\u5408\u6cd5");
            return Boolean.FALSE;
        }
        if ((long)this.normalPrice.intValue() <= Constant.MIN_SALE_PRICE || (long)this.finalPrice.intValue() <= Constant.MIN_SALE_PRICE) {
            log.warn("\u7ec4\u5408\u5546\u54c1\u4ef7\u683c\u4e0d\u5408\u6cd5");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public Integer getNormalPrice() {
        return this.normalPrice;
    }

    public Integer getFinalPrice() {
        return this.finalPrice;
    }

    public Integer getFclSinglePrice() {
        return this.fclSinglePrice;
    }

    public Integer getEwalletPrice() {
        return this.ewalletPrice;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public void setNormalPrice(Integer normalPrice) {
        this.normalPrice = normalPrice;
    }

    public void setFinalPrice(Integer finalPrice) {
        this.finalPrice = finalPrice;
    }

    public void setFclSinglePrice(Integer fclSinglePrice) {
        this.fclSinglePrice = fclSinglePrice;
    }

    public void setEwalletPrice(Integer ewalletPrice) {
        this.ewalletPrice = ewalletPrice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupProductPriceVo)) {
            return false;
        }
        GroupProductPriceVo other = (GroupProductPriceVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$productCode = this.getProductCode();
        String other$productCode = other.getProductCode();
        if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
            return false;
        }
        Integer this$normalPrice = this.getNormalPrice();
        Integer other$normalPrice = other.getNormalPrice();
        if (this$normalPrice == null ? other$normalPrice != null : !((Object)this$normalPrice).equals(other$normalPrice)) {
            return false;
        }
        Integer this$finalPrice = this.getFinalPrice();
        Integer other$finalPrice = other.getFinalPrice();
        if (this$finalPrice == null ? other$finalPrice != null : !((Object)this$finalPrice).equals(other$finalPrice)) {
            return false;
        }
        Integer this$fclSinglePrice = this.getFclSinglePrice();
        Integer other$fclSinglePrice = other.getFclSinglePrice();
        if (this$fclSinglePrice == null ? other$fclSinglePrice != null : !((Object)this$fclSinglePrice).equals(other$fclSinglePrice)) {
            return false;
        }
        Integer this$ewalletPrice = this.getEwalletPrice();
        Integer other$ewalletPrice = other.getEwalletPrice();
        return !(this$ewalletPrice == null ? other$ewalletPrice != null : !((Object)this$ewalletPrice).equals(other$ewalletPrice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupProductPriceVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $productCode = this.getProductCode();
        result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
        Integer $normalPrice = this.getNormalPrice();
        result = result * 59 + ($normalPrice == null ? 43 : ((Object)$normalPrice).hashCode());
        Integer $finalPrice = this.getFinalPrice();
        result = result * 59 + ($finalPrice == null ? 43 : ((Object)$finalPrice).hashCode());
        Integer $fclSinglePrice = this.getFclSinglePrice();
        result = result * 59 + ($fclSinglePrice == null ? 43 : ((Object)$fclSinglePrice).hashCode());
        Integer $ewalletPrice = this.getEwalletPrice();
        result = result * 59 + ($ewalletPrice == null ? 43 : ((Object)$ewalletPrice).hashCode());
        return result;
    }

    public String toString() {
        return "GroupProductPriceVo(productCode=" + this.getProductCode() + ", normalPrice=" + this.getNormalPrice() + ", finalPrice=" + this.getFinalPrice() + ", fclSinglePrice=" + this.getFclSinglePrice() + ", ewalletPrice=" + this.getEwalletPrice() + ")";
    }
}

