/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.model.promotion.enums.PromotionTargetLimitTypeEnum;
import com.biz.model.promotion.vo.BasePromotionVo;
import com.biz.model.promotion.vo.DiscountRateVo;
import com.biz.primus.common.utils.ValueUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@ApiModel(value="\u6298\u6263\u4fc3\u9500Vo")
public class DiscountPromotionVo
extends BasePromotionVo {
    private static final long serialVersionUID = -7005332458636717857L;
    @ApiModelProperty(value="\u662f\u5426\u9636\u68af\u6298\u6263")
    private Boolean isStairCut = false;
    @ApiModelProperty(value="\u9636\u68af\u6570\u91cf")
    private Integer stairCount;
    @ApiModelProperty(value="\u6309\u7167\u5546\u54c1\u91d1\u989d/\u5546\u54c1\u6570\u91cf\u6298\u6263", allowableValues="DISCOUNT_BY_PRODUCT_AMOUNT, DISCOUNT_BY_PRODUCT_QUANTITY")
    private PromotionTargetLimitTypeEnum limitType;
    @ApiModelProperty(value="\u6298\u6263\u7387")
    private List<DiscountRateVo> discountRates;

    public Map<Integer, BigDecimal> toRateMap() {
        TreeMap ret = Maps.newTreeMap();
        if (CollectionUtils.isNotEmpty(this.discountRates)) {
            this.discountRates.forEach(rate -> ret.put(rate.getRateCondition(), rate.getDiscountRate()));
        }
        return ret;
    }

    public void mapIntoRates(Map<Integer, BigDecimal> rates) {
        ArrayList rateVos = Lists.newArrayList();
        if (MapUtils.isNotEmpty(rates)) {
            rates.forEach((k, v) -> rateVos.add(new DiscountRateVo((Integer)k, (BigDecimal)v)));
        }
        this.discountRates = rateVos;
    }

    @Override
    public void validate() {
        super.validate();
        AssertUtils.notNull((Object)((Object)this.limitType), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4fc3\u9500\u6761\u4ef6\u9650\u5236\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.discountRates), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        this.discountRates.forEach(discountRateVo -> {
            AssertUtils.isTrue((ValueUtils.getValue((Integer)discountRateVo.getRateCondition()) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u6298\u6263\u6761\u4ef6\u9519\u8bef");
            AssertUtils.isTrue((Objects.nonNull(discountRateVo.getDiscountRate()) && discountRateVo.getDiscountRate().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u6298\u6263\u7387\u5e94\u8be5\u662f0-1\u4e4b\u95f4\u7684\u5c0f\u6570, \u5c0f\u6570\u4f4d\u6570\u5e94\u9650\u5236\u5728\u4e24\u4f4d");
        });
    }

    public void setIsStairCut(Boolean isStairCut) {
        this.isStairCut = isStairCut;
    }

    public void setStairCount(Integer stairCount) {
        this.stairCount = stairCount;
    }

    public void setLimitType(PromotionTargetLimitTypeEnum limitType) {
        this.limitType = limitType;
    }

    public void setDiscountRates(List<DiscountRateVo> discountRates) {
        this.discountRates = discountRates;
    }

    public Boolean getIsStairCut() {
        return this.isStairCut;
    }

    public Integer getStairCount() {
        return this.stairCount;
    }

    public PromotionTargetLimitTypeEnum getLimitType() {
        return this.limitType;
    }

    public List<DiscountRateVo> getDiscountRates() {
        return this.discountRates;
    }
}

