/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.enums.promotion.LuckyOrderTypeEnum;
import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.base.vo.promotion.PromotionCouponVo;
import com.biz.base.vo.promotion.PromotionGiftTypeEnum;
import com.biz.model.promotion.vo.BasePromotionVo;
import com.biz.primus.common.support.jackson.PrimusLocalDateTimeDeserializer;
import com.biz.primus.common.support.jackson.PrimusLocalDateTimeSerializer;
import com.biz.primus.common.utils.ValueUtils;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="\u9996\u5355\u6709\u793c\u4fc3\u9500Vo")
public class LuckyOrderPromotionVo
extends BasePromotionVo {
    private static final long serialVersionUID = 2787841567105019747L;
    @ApiModelProperty(value="\u4e0b\u5355\u6709\u793c\u7c7b\u578b(\u6309\u7167\u65f6\u95f4\u6bb5\u8bbe\u7f6e\u4e2d\u5956\u8fd8\u662f\u6309\u7167\u5f53\u65e5\u4e0b\u5355\u6570\u91cf\u8bbe\u7f6e\u4e2d\u5956)")
    private LuckyOrderTypeEnum luckyOrderType;
    @ApiModelProperty(value="\u8d60\u54c1\u7c7b\u578b")
    private PromotionGiftTypeEnum giftType;
    @ApiModelProperty(value="\u5956\u5238\u96c6\u5408")
    private List<PromotionCouponVo> giftCoupons;
    @ApiModelProperty(value="\u8d60\u9001\u79ef\u5206\u6570\u91cf")
    private Integer pointQuantity;
    @ApiModelProperty(value="\u6d3b\u52a8\u95e8\u69db\u91d1\u989d")
    private Integer limitAmount;
    @JsonDeserialize(using=PrimusLocalDateTimeDeserializer.class)
    @JsonSerialize(using=PrimusLocalDateTimeSerializer.class)
    @ApiModelProperty(value="\u4e0b\u5355\u6709\u793c\u65f6\u95f4\u6bb5\u5f00\u59cb\u65f6\u95f4")
    private LocalDateTime luckyOrderStartTime;
    @JsonDeserialize(using=PrimusLocalDateTimeDeserializer.class)
    @JsonSerialize(using=PrimusLocalDateTimeSerializer.class)
    @ApiModelProperty(value="\u4e0b\u5355\u6709\u793c\u65f6\u95f4\u6bb5\u7ed3\u675f\u65f6\u95f4")
    private LocalDateTime luckyOrderEndTime;
    @ApiModelProperty(value="\u4e2d\u5956\u8ba2\u5355\u6570(\u5f53\u65e5\u7b2cxx\u5355\u4e2d\u5956)")
    private Set<Integer> luckyOrderSequence;
    @ApiModelProperty(value="\u4e0b\u5355\u65f6\u95f4\u6bb5\u5185\u4e2d\u5956\u6570\u9650\u5236")
    private Integer lucyOrderTimeSectionLuckyQuantity;

    @Override
    public void validate() {
        super.validate();
        AssertUtils.notNull((Object)this.luckyOrderType, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e0b\u5355\u6709\u793c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.luckyOrderType == LuckyOrderTypeEnum.BY_ORDER_TIME_RANGE) {
            AssertUtils.notNull((Object)this.luckyOrderStartTime, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e0b\u5355\u6709\u793c\u4e2d\u5956\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)this.luckyOrderEndTime, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e0b\u5355\u6709\u793c\u4e2d\u5956\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)this.luckyOrderStartTime.isBefore(this.luckyOrderEndTime), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e0b\u5355\u6709\u793c\u4e2d\u5956\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u4e0b\u5355\u6709\u793c\u4e2d\u5956\u7ed3\u675f\u65f6\u95f4");
            AssertUtils.isTrue((ValueUtils.getValue((Integer)this.lucyOrderTimeSectionLuckyQuantity) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e0b\u5355\u65f6\u95f4\u6bb5\u5185\u4e2d\u5956\u6570\u9650\u5236\u6570\u5fc5\u987b\u5927\u4e8e0");
        } else {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.luckyOrderSequence), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e2d\u5956\u8ba2\u5355\u6570(\u5f53\u65e5\u7b2cxx\u5355\u4e2d\u5956)\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AssertUtils.notNull((Object)this.giftType, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u5956\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((PromotionGiftTypeEnum.PRODUCT != this.giftType ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u4e0b\u5355\u6709\u793c\u6d3b\u52a8\u4e0d\u652f\u6301\u8d60\u9001\u5546\u54c1");
        if (this.giftType == PromotionGiftTypeEnum.COUPON) {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.giftCoupons), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u5956\u54c1\u4f18\u60e0\u5238\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            AssertUtils.isTrue((ValueUtils.getValue((Integer)this.pointQuantity) > 0 ? 1 : 0) != 0, (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u5956\u54c1\u79ef\u5206\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public LuckyOrderTypeEnum getLuckyOrderType() {
        return this.luckyOrderType;
    }

    public PromotionGiftTypeEnum getGiftType() {
        return this.giftType;
    }

    public List<PromotionCouponVo> getGiftCoupons() {
        return this.giftCoupons;
    }

    public Integer getPointQuantity() {
        return this.pointQuantity;
    }

    public Integer getLimitAmount() {
        return this.limitAmount;
    }

    public LocalDateTime getLuckyOrderStartTime() {
        return this.luckyOrderStartTime;
    }

    public LocalDateTime getLuckyOrderEndTime() {
        return this.luckyOrderEndTime;
    }

    public Set<Integer> getLuckyOrderSequence() {
        return this.luckyOrderSequence;
    }

    public Integer getLucyOrderTimeSectionLuckyQuantity() {
        return this.lucyOrderTimeSectionLuckyQuantity;
    }

    public void setLuckyOrderType(LuckyOrderTypeEnum luckyOrderType) {
        this.luckyOrderType = luckyOrderType;
    }

    public void setGiftType(PromotionGiftTypeEnum giftType) {
        this.giftType = giftType;
    }

    public void setGiftCoupons(List<PromotionCouponVo> giftCoupons) {
        this.giftCoupons = giftCoupons;
    }

    public void setPointQuantity(Integer pointQuantity) {
        this.pointQuantity = pointQuantity;
    }

    public void setLimitAmount(Integer limitAmount) {
        this.limitAmount = limitAmount;
    }

    public void setLuckyOrderStartTime(LocalDateTime luckyOrderStartTime) {
        this.luckyOrderStartTime = luckyOrderStartTime;
    }

    public void setLuckyOrderEndTime(LocalDateTime luckyOrderEndTime) {
        this.luckyOrderEndTime = luckyOrderEndTime;
    }

    public void setLuckyOrderSequence(Set<Integer> luckyOrderSequence) {
        this.luckyOrderSequence = luckyOrderSequence;
    }

    public void setLucyOrderTimeSectionLuckyQuantity(Integer lucyOrderTimeSectionLuckyQuantity) {
        this.lucyOrderTimeSectionLuckyQuantity = lucyOrderTimeSectionLuckyQuantity;
    }
}

