/*
 * Decompiled with CFR 0.152.
 */
package com.biz.model.promotion.vo;

import com.biz.base.exception.ExceptionType;
import com.biz.base.exception.promotion.PromotionExceptionType;
import com.biz.base.exception.utils.AssertUtils;
import com.biz.model.promotion.vo.BasePromotionVo;
import com.biz.model.promotion.vo.SeckillProductVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ApiModel(value="\u79d2\u6740\u6d3b\u52a8Vo")
public class SeckillPromotionVo
extends BasePromotionVo {
    private static final long serialVersionUID = 3992868054930961232L;
    @ApiModelProperty(value="\u79d2\u6740\u6d3b\u52a8\u5546\u54c1")
    private List<SeckillProductVo> seckillProducts;
    @ApiModelProperty(value="\u79d2\u6740\u6d3b\u52a8\u5546\u54c1\u540d")
    private List<String> seckillProductNames;

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public void vaildate() {
        super.validate();
        LocalDate startTime = LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse(super.getStartTime())).toLocalDate();
        LocalDate endTime = LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse(super.getEndTime())).toLocalDate();
        AssertUtils.isTrue((boolean)startTime.isEqual(endTime), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u5f00\u59cb\u65e5\u671f\u4e0e\u7ed3\u675f\u65e5\u671f\u5e94\u8be5\u4e3a\u540c\u4e00\u5929");
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(this.seckillProducts), (ExceptionType)PromotionExceptionType.ILLEGAL_PARAMETER, (String)"\u79d2\u6740\u6d3b\u52a8\u7684\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public List<SeckillProductVo> getSeckillProducts() {
        return this.seckillProducts;
    }

    public List<String> getSeckillProductNames() {
        return this.seckillProductNames;
    }

    public void setSeckillProducts(List<SeckillProductVo> seckillProducts) {
        this.seckillProducts = seckillProducts;
    }

    public void setSeckillProductNames(List<String> seckillProductNames) {
        this.seckillProductNames = seckillProductNames;
    }
}

